package IRed.spectro.stamped;

import java.io.DataOutputStream;
import java.io.IOException;

public class FloatType extends DataType {

	public FloatType () {
		super(1);
	}

	private FloatType (FloatType orig) {
		super(orig);
	}

	public boolean assignable(DataType rhs) {
		return rhs instanceof IntegerType || rhs instanceof FloatType;
	}

	public DataType clone() {
		return new FloatType(this);
	}

   public boolean equals(Object o) {
      return o instanceof FloatType;
   }

	public DataType resolveType() {return this;}

	public void dump(String left) {
		System.out.println(left + "Float");
	}

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(Tag.FLOAT);
   }

}
