package IRed.spectro.stamped;

public class ForAST extends AST {
   SymbolTable bodyScope;
   TypedAST init, bound, inc;
   boolean dwn;
   AST body;

   public ForAST(int line, int col, SymbolTable bodyScope, TypedAST init, TypedAST bound, TypedAST inc, boolean dwn, AST body) {
      super(line, col);
      this.bodyScope = bodyScope; this.init = init; this.bound = bound; this.inc = inc; this.dwn = dwn; this.body = body;
   }

   public boolean distributeTypes(boolean isFunBody) {
      if (!init.distributeTypes()) return false;
      if (!bound.distributeTypes()) return false;
      if (!inc.distributeTypes()) return false;
      if (!bodyScope.resolveTypes()) throw new FatalError("internal error in for loop");
      bodyScope.allocateForVar();
      if (!body.distributeTypes()) return false;
      
      if (!(init.type instanceof IntegerType)) {
         SemErr("initializer must be an INTEGER");
         return false;
      }
      if (!(bound.type instanceof IntegerType)) {
         SemErr("loop bound must be an INTEGER");
         return false;
      }
      if (!(inc.type instanceof IntegerType)) {
         SemErr("increment must be an INTEGER");
         return false;
      }
      return true;
   }

   public void setEnclosingProc(ProcType proc) {
      body.setEnclosingProc(proc);
   }

	public void generateCode(boolean isTry) {
      bound = bound.moveVal2Stack();
      if (!(bound instanceof ConstIntAST)) Warning("undefined real-time behavior, loop bound should be a constant");
      bound.forceVal2Stack();
      inc = inc.moveVal2Stack();
      if (!(inc instanceof ConstIntAST)) {
         Warning("undefined real-time behavior, loop increment should be a constant");
         inc.forceVal2Stack();
         if (dwn) Compiler.code.Emit(Instruction.NEG, "");
      } else if (dwn) {
         int val = -((ConstIntAST)inc).val;
         Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(val), false, "constant " + val);
      } else inc.forceVal2Stack();
      init = init.moveVal2Stack();
      if (!(init instanceof ConstIntAST)) Warning("undefined real-time behavior, loop initializer should be a constant");
      init.forceVal2Stack();
      Code.Label loops = Compiler.code.genLabel(), loope = Compiler.code.genLabel();
      Compiler.code.setLabel(loops);
      Compiler.code.Emit(((dwn) ? Instruction.DWNFORTST : Instruction.UPFORTST), loope, "");      
      body.generateCode(isTry);
      Compiler.code.Emit(Instruction.FOREND, loops, "");
      Compiler.code.setLabel(loope);
   }

	public void dump(String left) {
      String dir = ((dwn) ? " downto" : " to");
      System.out.println(left + "for" + dir);
      init.dump(left + "   ");
      inc.dump(left + "   ");
      bound.dump(left + "   ");
      body.dump(left + "   ");

   }

}
