package IRed.spectro.stamped;

import java.util.List;

public class FunCallAST extends TypedAST {
	ActParsAST params;
	RefAST funName;

	public FunCallAST(int line, int col, RefAST f, ActParsAST p) {
		super(line, col);
		funName = f;
		params = p;
	}

	public TypedAST resolveConst() {return this;}

   public boolean distributeTypes(boolean isFunBody) {
      if (!funName.distributeTypes()) return false;
      if (!(funName.getType() instanceof ProcType)) {
         System.out.println("in FunCallAST distributeTypes");
         SemErr("not declared as PROCEDURE");
         return false;
      }
      ProcType ty = (ProcType)funName.getType();
      if (ty.retType == null) {
         SemErr("PROCEDURE returns no value");
         return false;
      }
      ty.retType = ty.retType.resolveType();
      if (params == null) {
         if (ty.parcnt != 0) {
            SemErr("wrong number of arguments in call");
            return false;
         }
      } else if (!params.distributeTypes()) return false;
      if (params != null && !params.checkTypes(ty.parcnt, ty.locals)) return false;
      type = ty.retType;
      return true;
   }

   public void moveAddr2Stack(boolean check) {
      // System.out.println("in FunCallAST.moveAddr2Stack");
      moveVal2Stack();
      // System.out.println("out FunCallAST.moveAddr2Stack, place = " + place);
   }

   public void forceAddr2Stack() {
      // System.out.println("in FunCallAST.forceAddr2Stack");
      moveVal2Stack();
      // System.out.println("out FunCallAST.forceAddr2Stack, place = " + place);
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }
  
   public TypedAST moveVal2Stack() {
      // System.out.println("in FunCallAST.moveVal2Stack");
      ProcType ty = (ProcType)funName.getType();
      if (params != null) params.move2Stack(ty. parcnt, ty.locals);
      Compiler.code.Emit(Instruction.CALL, ty.label, "");      
      place = Place.VALONSTACK;
      // System.out.println("out FunCallAST.moveVal2Stack, place = " + place);
      return this;
   }

   public void forceVal2Stack() {
   }

	public void dump(String left) {
		System.out.println(left + "Function Call");
		funName.dump(left + "   ");
		if (params != null) params.dump(left + "   ");
      if (type != null) type.dump(left + "   ");
	}

}
