package IRed.spectro.stamped;

import java.util.LinkedList;

public class IfAST extends AST {

   class CondSequence {
      TypedAST cond;
      SequenceAST alt;

      CondSequence (TypedAST cond, SequenceAST alt) {
         this.cond = cond; this.alt = alt;
      }

   }

   LinkedList<CondSequence> alts;

   public IfAST(int line, int col, TypedAST cond, SequenceAST thenAlt) {
      super(line, col);
      alts = new LinkedList<CondSequence>();
      alts.add(new CondSequence(cond, thenAlt));
   }

   public void addElsIf(TypedAST cond, SequenceAST alt) {
      alts.add(new CondSequence(cond, alt));
   }

   public void addElse(SequenceAST alt) {
      alts.add(new CondSequence(null, alt));
   }      

   public boolean distributeTypes(boolean isFunBody) {
      // System.out.println("in IfAST distributeTypes"); 
      for (CondSequence cs: alts) {
         if (cs.cond != null && !cs.cond.distributeTypes()) return false;
         if (cs.cond != null && !(cs.cond.type instanceof BoolType)) {
            SemErr("Condition must be BOOLEAN");
            return false;
         }
         if (!cs.alt.distributeTypes()) return false; 
      }
      // System.out.println("out IfAST distributeTypes");
      return true;
   }

   public void setEnclosingProc(ProcType proc) {
      for (CondSequence cs: alts) {
         if (cs.cond != null) cs.cond.setEnclosingProc(proc);
         cs.alt.setEnclosingProc(proc);
      }
   }

	public void generateCode(boolean isTry) {
      Code.Label end = Compiler.code.genLabel(), nxtAlt = null;
      for (CondSequence cs: alts) {
         if (nxtAlt != null) {
            Compiler.code.Emit(Instruction.JMP, end, "");
            Compiler.code.setLabel(nxtAlt);
         }
         if (cs.cond != null) {
            nxtAlt = Compiler.code.genLabel();
            cs.cond = cs.cond.moveVal2Stack();
            cs.cond.forceVal2Stack();
            Compiler.code.Emit(Instruction.FALSEJMP, nxtAlt, "");
         } else 
            nxtAlt = null;
         cs.alt.generateCode(isTry);
      }

      if (nxtAlt != null) Compiler.code.setLabel(nxtAlt);
      Compiler.code.setLabel(end);
   }

	public void dump(String left) {
      System.out.println(left + "if");
      for (CondSequence cs: alts) {
         if (cs.cond != null) cs.cond.dump(left + "   ");
         cs.alt.dump(left + "   ");
      }
   }

}
