package IRed.spectro.stamped;

enum ArgTy {
   address,
   offset,
   size,
   local,
   lock,
   count,
   blob,
   bloblst,
   none
}


public enum Instruction {
   LOAD     (ArgTy.address,   ArgTy.blob,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x00),
   LOADA    (ArgTy.address,   ArgTy.size,       ArgTy.blob,       ArgTy.none,       ArgTy.none,    2,    0x01),
   LOADL    (ArgTy.offset,    ArgTy.blob,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x02),
   LOADAL   (ArgTy.offset,    ArgTy.size,       ArgTy.blob,       ArgTy.none,       ArgTy.none,    2,    0x03),
   LOADV    (ArgTy.blob,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x04),
   LOADM    (ArgTy.address,   ArgTy.local,      ArgTy.count,      ArgTy.lock,       ArgTy.bloblst, 2,    0x05),
   LOADMV   (ArgTy.count,     ArgTy.bloblst,    ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x06),   // lock is specified in the address passed on the stack!!! 
   
   STORE    (ArgTy.address,   ArgTy.blob,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x10),
   STOREA   (ArgTy.address,   ArgTy.size,       ArgTy.blob,       ArgTy.none,       ArgTy.none,    2,    0x11),
   STOREL   (ArgTy.offset,    ArgTy.blob,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x12),
   STOREAL  (ArgTy.offset,    ArgTy.size,       ArgTy.blob,       ArgTy.none,       ArgTy.none,    2,    0x13),
   STOREM   (ArgTy.address,   ArgTy.local,      ArgTy.count,      ArgTy.lock,       ArgTy.bloblst, 2,    0x14),
   STOREMV  (ArgTy.count,     ArgTy.bloblst,    ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x15),   // lock is specified in the address passed on the stack!!!  
   STOREP   (ArgTy.size,      ArgTy.count,      ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x16),   // first arg is offset with respect to SP of the first LHS, 
                                                                                                                  // second arg is offset of first RHS
   ADDFP    (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x20),
   CHECK    (ArgTy.size,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x21),
   XTRACT   (ArgTy.count,     ArgTy.offset,     ArgTy.size,       ArgTy.bloblst,    ArgTy.none,    2,    0x22),
   STKAREF  (ArgTy.count,     ArgTy.size,       ArgTy.bloblst,    ArgTy.none,       ArgTy.none,    2,    0x23),

   ADD      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x30),
   SUB      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x31),
   MUL      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x32),
   DIV      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x33),
   MOD      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x34),
   NEG      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x35),
   AND      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x36),
   OR       (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x37),
   XOR      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x38),
   NOT      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x39),
   DURATION (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x3A),
   EARLIEST (ArgTy.count,     ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x3B),
   LATEST   (ArgTy.count,     ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x3C),   

   LT       (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x40),
   LE       (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x41),
   EQ       (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x42),
   GE       (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x43),
   GT       (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x44),
   NEQ      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x45),

   FADD     (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x50),
   FSUB     (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x51),
   FMUL     (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x52),
   FDIV     (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x53),
   FNEG     (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x54),

   FLT      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x60),
   FLE      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x61),
   FEQ      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x62),
   FGE      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x63),
   FGT      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x64),
   FNEQ     (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x65),

   TOFLOAT  (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x70),
   TOINT    (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x71),

   JMP      (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x80),
   ANDJMP   (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x81),
   ORJMP    (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x82),
   FALSEJMP (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x83),
   TRUEJMP  (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x84),
   CALL     (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x85),
   ENTER    (ArgTy.size,      ArgTy.bloblst,    ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x86),
   RETURN   (ArgTy.count,     ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x87),
   FRETURN  (ArgTy.count,     ArgTy.size,       ArgTy.none,       ArgTy.none,       ArgTy.none,    2,    0x88),
   COMPCALL (ArgTy.count,     ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x89),

   UPFORTST (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x90),
   DWNFORTST(ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x91),
   FOREND   (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x92),
   TRY      (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x93),
   THROW    (ArgTy.address,   ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x94),
   TRYEND   (ArgTy.offset,    ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0x95),
   STOP     (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    1,    0xA0),
   NOP      (ArgTy.none,      ArgTy.none,       ArgTy.none,       ArgTy.none,       ArgTy.none,    0,    0xFF);

   public final ArgTy t1, t2, t3, t4, t5;
   public final int wordCount, opCode;

   private Instruction(ArgTy t1, ArgTy t2, ArgTy t3, ArgTy t4, ArgTy t5, int wordCount, int opCode) {
      this.t1 = t1; this.t2 = t2; this.t3 = t3; this.t4 = t4; this.t5 = t5; this.wordCount = wordCount; this.opCode = opCode;
   }   
}


