package IRed.spectro.stamped;

import java.io.DataOutputStream;
import java.io.IOException;

public class IntegerType extends DataType {

	public IntegerType () {
		super(1);
	}

	private IntegerType (IntegerType orig) {
		super(orig);
	}

	public boolean assignable(DataType rhs) {
		return rhs instanceof IntegerType || rhs instanceof FloatType;
	}

	public DataType clone() {
		return new IntegerType(this);
	}

   public boolean equals(Object o) {
      return o instanceof IntegerType;
   }

	public DataType resolveType() {return this;}

	public void dump(String left) {
		System.out.println(left + "Integer");
	}

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(Tag.INTEGER);
   }

}
