package IRed.spectro.stamped;

import java.util.List;

public class LhsAST extends TypedAST  {
   String name;
   SymbolTable scope;
   TypedAST index;
   ArrayType atype;

    public LhsAST(int line, int col, String name, SymbolTable scope, TypedAST index) {
      super(line, col, null);
      this.name = name;
      this.scope = scope;
      this.index = index;
      atype = null;
   }

	public TypedAST resolveConst() {
		return this;
	}

   public boolean distributeTypes(boolean isFunBody) {
      if (!valid) {
         if (type != null)
            SemErr("internal error in lhs");
         else {         
            Symbol s = scope.find(name);
            if (s == null) SemErr(name + " not declared");
            else {
               type = s.type;
               if (!s.mapped) throw new FatalError("variable " + name + " has not been mapped");
               offset = s.offset;
               readOnly = s.readOnly;
               kind = s.kind;
               if (index == null)
                  valid = true;
               else {  
                  if (!index.distributeTypes()) return false;
                  if (!(index.getType() instanceof IntegerType)) SemErr("index must be an INTEGER");
                  if (!(type instanceof ArrayType)) SemErr("not an ARRAY");
                  atype = (ArrayType)type;
                  type = atype.basicTy;
                  valid = true;
               }
            }
         }
      }
      return valid;
   }

   public TypedAST moveVal2Stack() {
      throw new FatalError("internal error, invalid moveVal2Stack");
   }

   public void forceVal2Stack() {
      throw new FatalError("internal error, invalid forceVal2Stack");
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public void moveAddr2Stack(boolean check) {
      // System.out.println("in LhsAST.moveAddr2Stack, place = " + place + " kind = " + kind);
      if (kind == Kind.STATICVAR || kind == Kind.SHAREDVAR || kind == Kind.COMPVAR || kind == Kind.LOCALVAR) {
         if (index == null) place = Place.CONSTADDR;
         else {
            index = index.moveVal2Stack();
            if (index.place == Place.CONSTVAL) {
               int i = ((ConstIntAST)index).val;
               if (i >= atype.no) SemErr("constant index out of bounds");
               offset += i * type.size;
               place = Place.CONSTADDR;
            } else if (index.place == Place.VALONSTACK) {
               if (type.size > 1) {
                  // for size > 1 checking is necessary as the STOREMV instruction does not check adresses
                  Compiler.code.Emit(Instruction.CHECK, atype.no, "");
                  Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(type.size), false, "size of data: " + type.size);
                  Compiler.code.Emit(Instruction.MUL, "");
                  place = Place.INDEXESONSTACK;
               } else {
                  place = Place.INDEXONSTACK;
               }
            }
         }
      } else if (kind == Kind.VARPAR && place == Place.NOWHERE) {
         Compiler.code.Emit(Instruction.LOADL, offset, false, "");
         if (index !=  null) {
            index = index.moveVal2Stack();
            if (index.place == Place.CONSTVAL) {
               int i = ((ConstIntAST)index).val;
               if (i >= atype.no) SemErr("constant index out of bounds");
               i *= type.size;
               Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(i), false, "constant index " + i);
            } else if (index.place == Place.VALONSTACK) {
               // for size > 1 checking is necessary as the STOREMV instruction does not check adresses
               Compiler.code.Emit(Instruction.CHECK, atype.no, "");
               if (type.size > 1) {
                  Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(type.size), false, "size of data: " + type.size);
                  Compiler.code.Emit(Instruction.MUL, "");
               }
            }
            Compiler.code.Emit(Instruction.ADD, "");
         }
         place = Place.ADDRONSTACK;
      }
      // System.out.println("out LhsAST.moveAddr2Stack, place = " + place);
   }

   public void forceAddr2Stack() {
      // dump("in forceAddr2Stack ");
      if (place == Place.ADDRONSTACK) return;
      if (place == Place.CONSTADDR) {
         if (kind == Kind.LOCALVAR) Compiler.code.Emit(Instruction.ADDFP, offset, "local variable");
         else Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(offset), false, "constant address " + offset);
      } else if (place == Place.INDEXONSTACK) {
         if (kind == Kind.LOCALVAR) Compiler.code.Emit(Instruction.ADDFP, offset, "local array variable");
         else Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(offset), false, "constant array address " + offset);
         Compiler.code.Emit(Instruction.ADD, "");
      } else if (place == Place.INDEXESONSTACK) {
         int o = offset;
         String l = "";
         if ((kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) && type.size > 1) {
            o |= 0x80000000; l = " locked";
         }
         Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o), false, "constant address " + offset + l);
         Compiler.code.Emit(Instruction.ADD, "");
         place = Place.ADDRONSTACK;
      } else throw new FatalError("internal error, cannot force address");
      place = Place.ADDRONSTACK;
   }

   public void dump(String left) {
      System.out.println(left + "lhs " + name);
      if (index != null) index.dump(left + "   index = ");
      else System.out.println(left + "   index = null");
      if (atype != null) atype.dump(left + "   atype = ");
      else System.out.println(left + "   atype = null");
      if (type != null) type.dump(left + "   type = ");
      else System.out.println(left + "   type = null");
   }

}


