package IRed.spectro.stamped;

import java.util.List;

public class LhsQualAST extends TypedAST  {
   TypedAST base;
   String qual;
   TypedAST index;
   ArrayType atype;

   public LhsQualAST(int line, int col, TypedAST base, String qual, TypedAST index) {
      super(line, col, null);
      this.base = base;
      this. qual = qual;
      this.index = index;
      valid = false;
   }

	public TypedAST resolveConst() {
		return this;
	}

   public boolean distributeTypes(boolean isFunBody) {
      if (!valid) {
         if (type != null)
            throw new FatalError("internal error in lhs qualifier");
         else {
            if (!base.distributeTypes()) return false;
            if (!(base.getType() instanceof RecordType)) {
               SemErr("base type is not RECORD");
               return false;
            }         

            SymbolTable baseSyms = ((RecordType)(base.getType())).fields;
            Symbol s = baseSyms.find(qual);
            if (s == null) {
               SemErr("invalid RECORD or COMPONENT qualifier");
               return false;
            }
            // s.dump("in LhsQualAST distributeTypes: s = ");
            type = s.type;
            if (!s.mapped) throw new FatalError("record has not been mapped");
            offset = s.offset;
            readOnly = base.readOnly;
            kind = base.kind;

            if (index == null)
               valid = true;
            else {  
               if (!index.distributeTypes()) return false;
               if (!(index.getType() instanceof IntegerType)) SemErr("index must be an INTEGER");
               if (!(type instanceof ArrayType)) SemErr("not an ARRAY");
               atype = (ArrayType)type;
               type = atype.basicTy;
               valid = true;
            }
         }
      }
      return valid;
   }

   public TypedAST moveVal2Stack() {
      throw new FatalError("internal error, invalid moveVal2Stack");
   }

   public void forceVal2Stack() {
      throw new FatalError("internal error, invalid forceVal2Stack");
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public void moveAddr2Stack(boolean check) {
      base.moveAddr2Stack(check);
      if (base.place == Place.CONSTADDR) {
         offset += base.offset;
         if (index  == null) {
            place = Place.CONSTADDR;
         } else {
            index.moveVal2Stack();
            if (index.place == Place.CONSTVAL) {
               int i = ((ConstIntAST)index).val;
               if (i >= atype.no) SemErr("constant index out of bounds");
               offset += i * type.size;
               place = Place.CONSTADDR;
            } else if (index.place == Place.VALONSTACK) {
               if (type.size > 1) {
                  // checking is necessary as the STOREMV instruction does not check adresses
                  Compiler.code.Emit(Instruction.CHECK, atype.no, "");
                  Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(type.size), false, "size of data: " + type.size);
                  Compiler.code.Emit(Instruction.MUL, "");
                  place = Place.INDEXESONSTACK;
               } else {
                  place = Place.INDEXONSTACK;
               }
            }
         }
      } else if (base.place == Place.ADDRONSTACK) {
         if (index == null) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(offset), false, "");
            Compiler.code.Emit(Instruction.ADD, "");
            place = Place.ADDRONSTACK;
         } else {
            index.moveVal2Stack();
            if (index.place == Place.CONSTVAL) {
               int i = ((ConstIntAST)index).val;
               if (i >= atype.no) SemErr("constant index out of bounds");
               Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(i * type.size + offset), false, "constant index");
            } else if (index.place == Place.VALONSTACK) {
               // checking is necessary as the STOREMV instruction does not check adresses
               Compiler.code.Emit(Instruction.CHECK, atype.no, "");
               if (type.size > 1) {
                  Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(type.size), false, "size of data: " + type.size);
                  Compiler.code.Emit(Instruction.MUL, "");
               }
               if (offset != 0) {
                  Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(offset), false, "offset of field");
                  Compiler.code.Emit(Instruction.ADD, "");
               }
            }
            Compiler.code.Emit(Instruction.ADD, "");
            place = Place.ADDRONSTACK;
         }               
      } else if (base.place == Place.INDEXONSTACK || base.place == Place.INDEXESONSTACK) {
         offset += base.offset;
         if (index == null) place = base.place;
         else {
            index.moveVal2Stack();
            if (index.place == Place.CONSTVAL) {
               int i = ((ConstIntAST)index).val;
               if (i >= atype.no) SemErr("constant index out of bounds");
               offset += i * type.size;
               place = Place.INDEXESONSTACK;
            } else if (index.place == Place.VALONSTACK) {
               // checking is necessary as the STOREMV instruction does not check adresses
               Compiler.code.Emit(Instruction.CHECK, atype.no, "");
               if (type.size > 1) {
                  Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(type.size), false, "size of data: " + type.size);
                  Compiler.code.Emit(Instruction.MUL, "");
               }
               Compiler.code.Emit(Instruction.ADD, "");
               place = Place.INDEXESONSTACK;                              
            }
         }
      }
   }

   public void forceAddr2Stack() {
      if (place == Place.ADDRONSTACK) return;
      if (place == Place.CONSTADDR) {
         if (kind == Kind.LOCALVAR) Compiler.code.Emit(Instruction.ADDFP, offset, "local variable");
         else Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(offset), false, "constant address " + offset);
      } else if (place == Place.INDEXONSTACK || place == Place.INDEXESONSTACK) {
         if (kind == Kind.LOCALVAR) Compiler.code.Emit(Instruction.ADDFP, offset, "local variable");
         else Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(offset), false, "constant array address " + offset);
         Compiler.code.Emit(Instruction.ADD, ""); 
      } else throw new FatalError("internal error, cannot force address");
      place = Place.ADDRONSTACK;
  }

	public void dump(String left) {
		System.out.println(left + "lhs qualifier " + qual);
      base.dump(left + "   ");
      if (index != null) index.dump(left + "   index = ");
      else System.out.println(left + "   index = null");
      if (atype != null) atype.dump(left + "   atype = ");
      else System.out.println(left + "   atype = null");
      if (type != null) type.dump(left + "   type = ");
      else System.out.println(left + "   type = null");
	}

}
