package IRed.spectro.stamped;

import java.util.List;
import java.util.LinkedList;

public class LhsTuppleAST extends TypedAST {
   LinkedList<TypedAST> comps;
   int wrdCnt;

	public LhsTuppleAST(int line, int col) {
      super(line, col);
		type = null;
      valid = false;
      comps = new LinkedList<TypedAST>();
      wrdCnt = 0;
	}

   public void append(TypedAST ast) {
      comps.addLast(ast);
   }

	public TypedAST resolveConst() {
      return this;
   }

   public boolean distributeTypes(boolean isFunBody) {
      LinkedList<DataType> compTys = new LinkedList<DataType>();
      for (TypedAST comp: comps) {
         if (!comp.distributeTypes()) return false;
         compTys.addLast(comp.type);
      }      
      type = new TuppleType(compTys);
      return valid = true;
   }

   public TypedAST moveVal2Stack() {
      return this;
   }

   public void forceVal2Stack() {
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public void moveAddr2Stack(boolean check) {
      for (TypedAST comp: comps) {
         comp.moveAddr2Stack(false);
         comp.forceAddr2Stack();
         if (comp.place != Place.ADDRONSTACK) SemErr("Invalid lefthand side in tupple");
         List<Integer> blobOffsets = comp.type.getBlobOffsets(0);
         int bl = ((blobOffsets == null) ? 0 : blobOffsets.size());
         int modifier = comp.type.size | (bl << 16);
         Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(modifier), false, "modifier");
         wrdCnt += 2;
         if (bl > 0) {
            Compiler.code.Emit(Instruction.LOADM, Compiler.code.EmitConsts(blobOffsets), bl, false, false, null, "bloblist");
            wrdCnt += bl;
         }         
      }
   }

   public void forceAddr2Stack() {
   }

	public void dump(String left) {
      System.out.println(left + "reference tupple");
      for (TypedAST a: comps) a.dump(left + "   ");
   }

}
