package IRed.spectro.stamped;

import java.util.LinkedList;



public class Parser {
	public static final int _EOF = 0;
	public static final int _ident = 1;
	public static final int _number = 2;
	public static final int _float = 3;
	public static final int _string = 4;
	public static final int maxT = 78;

	static final boolean T = true;
	static final boolean x = false;
	static final int minErrDist = 2;

	public Token t;    // last recognized token
	public Token la;   // lookahead token
	int errDist = minErrDist;
	
	public Scanner scanner;
	public Errors errors;

	

	public Parser(Scanner scanner) {
		this.scanner = scanner;
		errors = new Errors();
	}

	void SynErr (int n) {
		if (errDist >= minErrDist) errors.SynErr(la.line, la.col, n);
		errDist = 0;
	}

	public void SemErr (String msg) {
		if (errDist >= minErrDist) errors.SemErr(t.line, t.col, msg);
		errDist = 0;
	}
	
	void Get () {
		for (;;) {
			t = la;
			la = scanner.Scan();
			if (la.kind <= maxT) {
				++errDist;
				break;
			}

			la = t;
		}
	}
	
	void Expect (int n) {
		if (la.kind==n) Get(); else { SynErr(n); }
	}
	
	boolean StartOf (int s) {
		return set[s][la.kind];
	}
	
	void ExpectWeak (int n, int follow) {
		if (la.kind == n) Get();
		else {
			SynErr(n);
			while (!StartOf(follow)) Get();
		}
	}
	
	boolean WeakSeparator (int n, int syFol, int repFol) {
		int kind = la.kind;
		if (kind == n) { Get(); return true; }
		else if (StartOf(repFol)) return false;
		else {
			SynErr(n);
			while (!(set[syFol][kind] || set[repFol][kind] || set[0][kind])) {
				Get();
				kind = la.kind;
			}
			return StartOf(syFol);
		}
	}
	
	void Stamped() {
		CompilationUnit();
	}

	void CompilationUnit() {
		if (la.kind == 5) {
			Program();
		} else if (la.kind == 74) {
			ComponentSpec();
		} else SynErr(79);
	}

	void Program() {
		Expect(5);
		SymbolTable sharedSyms = new SymbolTable();
		SequenceAST body;
		Compiler.tasks = new LinkedList<TaskAST>();
		Compiler.sharedSyms = sharedSyms;
		if (Compiler.compName != null)
		   SemErr("Not a component");
		
		if (la.kind == 13) {
			CmpntImport(sharedSyms);
			while (la.kind == 6) {
				Get();
				CmpntImport(sharedSyms);
			}
		}
		if (la.kind == 7) {
			Get();
			ConstDcl(sharedSyms);
			while (la.kind == 6) {
				Get();
				ConstDcl(sharedSyms);
			}
			if (!sharedSyms.resolveConsts()) 
			  SemErr("Unable to compute constants");
			  // sharedSyms.dump("");
			
		}
		if (la.kind == 8) {
			Get();
			TypeDcl(sharedSyms);
			while (la.kind == 6) {
				Get();
				TypeDcl(sharedSyms);
			}
			if (!sharedSyms.resolveTypes())
			  SemErr("Unable to resolve types");
			
		}
		if (la.kind == 9) {
			Get();
			StaticVarDcl(sharedSyms, Kind.SHAREDVAR);
			while (la.kind == 6) {
				Get();
				StaticVarDcl(sharedSyms, Kind.SHAREDVAR);
			}
			sharedSyms.allocateMemory(false, 0);
			Compiler.code.StaticSize += sharedSyms.size;
			// sharedSyms.dump(""); 
			
		}
		while (la.kind == 30) {
			ProcDcl(sharedSyms);
		}
		while (la.kind == 34) {
			TaskAST tAst; 
			tAst = TaskDcl(Compiler.code.StaticSize,  sharedSyms);
			Compiler.tasks.add(tAst);
			Compiler.code.StaticSize += tAst.taskSyms.size;   
			
		}
		Expect(10);
		body = StmntList(sharedSyms);
		Expect(11);
		if (body.distributeTypes()) {
		  // body.dump("");
		  body.generateCode();
		  Compiler.code.Emit(Instruction.STOP, "End of initialization");
		  sharedSyms.generateCode();
		}
		for (TaskAST tAst: Compiler.tasks) tAst.generateCode();
		// Compiler.code.dump();
		
		Expect(12);
	}

	void ComponentSpec() {
		String name; 
		Expect(74);
		name = Ident();
		SymbolTable compSyms = new SymbolTable();
		int procNo = 0;
		if (!name.equals(Compiler.compName)) SemErr("Component name does not match"); 
		
		if (la.kind == 7) {
			Get();
			ConstDcl(compSyms);
			while (la.kind == 6) {
				Get();
				ConstDcl(compSyms);
			}
			if (!compSyms.resolveConsts()) 
			  SemErr("Unable to compute constants");
			
		}
		if (la.kind == 8) {
			Get();
			TypeDcl(compSyms);
			while (la.kind == 6) {
				Get();
				TypeDcl(compSyms);
			}
			if (!compSyms.resolveTypes())
			  SemErr("Unable to resolve types");
			
		}
		if (la.kind == 75) {
			Get();
			ObjVarDcl(compSyms);
			while (la.kind == 6) {
				Get();
				ObjVarDcl(compSyms);
			}
		}
		if (la.kind == 24 || la.kind == 77) {
			EventDcl(compSyms);
			while (la.kind == 6) {
				Get();
				EventDcl(compSyms);
			}
		}
		if (la.kind == 30) {
			ProcInterfaceDcl(compSyms, procNo);
			procNo++; 
			while (la.kind == 6) {
				Get();
				ProcInterfaceDcl(compSyms, procNo);
				procNo++; 
			}
		}
		Expect(11);
		Expect(12);
		compSyms.allocateMemory(false, 0);
		// compSyms.dump("");
		Compiler.compSyms = compSyms;
		
	}

	void CmpntImport(SymbolTable syms) {
		String name; 
		Expect(13);
		name = Ident();
		java.io.FileInputStream fileIn = null;
		try {
		   fileIn = new java.io.FileInputStream(name + ".cmp");
		} catch (java.io.FileNotFoundException ex) {}
		if (fileIn == null) {
		   try {
		      fileIn = new java.io.FileInputStream
		      (Compiler.LibraryPath + "/" + name + ".cmp");
		   } catch (java.io.FileNotFoundException ex) {
		      SemErr("No such file " + name + ".cmp");
		   }
		}
		if (fileIn != null) {
		   try {
		      System.out.println("compiling component " + name);
		      Compiler.compName = name; 
		      Scanner CmpntScanner = new Scanner(fileIn);
		      Parser CmpntParser = new Parser(CmpntScanner);
		      CmpntParser.Parse();
		      fileIn.close();
		      System.out.println(CmpntParser.errors.count + " errors detected");
		   } catch (java.io.IOException ex) {
		      SemErr("Error reading " + name +".sym");
		   }
		}
		if (!syms.insert(name, new ComponentTy(name, Compiler.compSyms), false, Kind.COMPNAME))
		   SemErr("Component " + name + " imported twice");
		Compiler.compSyms = null; Compiler.compName = null;
		
	}

	void ConstDcl(SymbolTable syms) {
		String name;
		TypedAST ast;
		
		name = Ident();
		Expect(14);
		ast = Expr(syms);
		if (!syms.insert(name, ast, true, Kind.CONSTNAME))
		  SemErr("Constant " + name + " declared twice");
		
	}

	void TypeDcl(SymbolTable syms) {
		String name;
		DataType ty;
		
		name = Ident();
		Expect(15);
		ty = Type(syms, true);
		if (!syms.insert(name, ty, false, Kind.TYPENAME))
		  SemErr("Type " + name + "declared twice");
		
	}

	void StaticVarDcl(SymbolTable syms, Kind k) {
		DataType ty; 
		ty = Type(syms, false);
		StaticDclrand(ty, syms, k);
		while (la.kind == 27) {
			Get();
			StaticDclrand(ty, syms, k);
		}
	}

	void ProcDcl(SymbolTable outer) {
		String name; 
		DataType retType = null;
		int parcnt = 0;
		SequenceAST body;
		
		Expect(30);
		name = Ident();
		SymbolTable locals = new SymbolTable(outer);
		
		Expect(31);
		if (StartOf(1)) {
			parcnt = Fparams(locals);
		}
		Expect(32);
		if (la.kind == 33) {
			Get();
			if (StartOf(2)) {
				retType = Type(outer, false);
			} else if (la.kind == 25) {
				Get();
				DataType ty;
				LinkedList<DataType> compTypes = new LinkedList<DataType>();
				
				ty = Type(outer, false);
				compTypes.addLast(ty); 
				while (la.kind == 27) {
					Get();
					ty = Type(outer,false);
					compTypes.addLast(ty); 
				}
				retType = new TuppleType(compTypes); 
				Expect(26);
			} else SynErr(80);
		}
		if (la.kind == 9) {
			Get();
			VarDcl(locals, locals, false, Kind.LOCALVAR, false);
			while (la.kind == 6) {
				Get();
				VarDcl(locals, locals, false, Kind.LOCALVAR, false);
			}
		}
		Expect(10);
		body = StmntList(locals);
		Expect(11);
		ProcType proc = new ProcType(locals, parcnt, retType, body);
		if (!outer.insert(name, proc.resolveType(), false, Kind.PROCNAME))
		   SemErr("Multiple Declaration of " + name);
		body.setEnclosingProc(proc);
		
	}

	TaskAST  TaskDcl(int taskVarsStart, SymbolTable outer) {
		TaskAST  tast;
		String name;
		TypedAST idx = new ConstIntAST(0), period = null;
		SequenceAST body;
		Trigger trigger = null;
		
		Expect(34);
		name = Ident();
		SymbolTable taskSyms = new SymbolTable(outer, taskVarsStart); 
		if (la.kind == 35) {
			Get();
			period = Expr(outer);
		} else if (la.kind == 36) {
			Get();
			String compName, evName; 
			compName = Ident();
			Expect(12);
			evName = Ident();
			if (la.kind == 25) {
				Get();
				idx = Expr(outer);
				Expect(26);
			}
			Symbol comp = outer.find(compName);
			if (comp == null || !(comp.type instanceof ComponentTy)) SemErr("not a COMPONENT");
			Symbol ev = ((ComponentTy)comp.type).syms.find(evName);
			if (ev == null || !(ev.type instanceof EventType)) SemErr("not an EVENT");
			idx = idx.resolveConst();
			if (!(idx instanceof ConstIntAST)) SemErr("index not a constant INTEGER");
			int i = ((ConstIntAST)idx).val;
			if (i < 0 || i >= ((EventType)ev.type).no) SemErr("index out of bounds in EVENT ARRAY"); 
			trigger = new Trigger(comp, ev, i);
			taskSyms.copy(((EventType)ev.type).syms);
			
		} else SynErr(81);
		if (la.kind == 9) {
			Get();
			StaticVarDcl(taskSyms, Kind.STATICVAR);
			while (la.kind == 6) {
				Get();
				StaticVarDcl(taskSyms, Kind.STATICVAR);
			}
		}
		taskSyms.allocateMemory(false, 0); 
		while (la.kind == 30) {
			ProcDcl(taskSyms);
		}
		Expect(10);
		body = StmntList(taskSyms);
		Expect(11);
		tast =
		  new TaskAST(t.line, t.col, name, period, trigger, taskSyms, taskVarsStart,  body);        
		
		return tast;
	}

	SequenceAST  StmntList(SymbolTable scope) {
		SequenceAST  seq;
		AST ast; 
		ast = Statement(scope);
		seq = new SequenceAST(t.line, t.col, ast); 
		while (la.kind == 6) {
			Get();
			ast = Statement(scope);
			seq.append(ast); 
		}
		return seq;
	}

	String  Ident() {
		String  name;
		Expect(1);
		name = t.val; 
		return name;
	}

	TypedAST  Expr(SymbolTable scope) {
		TypedAST  ast;
		TypedAST sndAst; 
		ast = Term(scope);
		while (la.kind == 49) {
			Get();
			sndAst = Term(scope);
			ast = new BinaryOpAST(t.line, t.col, Operators.OR, ast, sndAst); 
		}
		return ast;
	}

	DataType  Type(SymbolTable syms, boolean unknwnOk) {
		DataType  ty;
		ty = null; 
		if (StartOf(3)) {
			ty = SimpleType();
		} else if (la.kind == 1 || la.kind == 22 || la.kind == 24) {
			ty = CompoundType(syms, unknwnOk);
		} else SynErr(82);
		return ty;
	}

	DataType  SimpleType() {
		DataType  ty;
		ty = null; 
		switch (la.kind) {
		case 16: {
			Get();
			ty = new IntegerType();     
			break;
		}
		case 17: {
			Get();
			ty = new FloatType();       
			break;
		}
		case 18: {
			Get();
			ty = new BoolType();        
			break;
		}
		case 19: {
			Get();
			ty = new BlobType();        
			break;
		}
		case 20: {
			Get();
			ty = new TimeStampType();   
			break;
		}
		case 21: {
			Get();
			ty = new StringType();      
			break;
		}
		default: SynErr(83); break;
		}
		return ty;
	}

	DataType  CompoundType(SymbolTable syms, boolean unknwnOk) {
		DataType  ty;
		String name;
		DataType ty1;
		TypedAST ast;
		
		ty = null;
		
		if (la.kind == 22) {
			Get();
			Expect(23);
			SymbolTable fields = new SymbolTable(); 
			VarDcl(fields, syms, false, Kind.FIELDNAME, unknwnOk);
			while (la.kind == 6) {
				Get();
				VarDcl(fields, syms, false, Kind.FIELDNAME, unknwnOk);
			}
			Expect(11);
			ty = new RecordType(fields); 
			
		} else if (la.kind == 24) {
			Get();
			Expect(25);
			ast = Expr(syms);
			Expect(26);
			Expect(23);
			ty1 = Type(syms, unknwnOk);
			ast = ast.resolveConst();
			if (!(ast instanceof ConstIntAST))
			   SemErr("Index must be an INTEGER constant"); 
			ty = new ArrayType(((ConstIntAST)ast).val, ty1); 
			
		} else if (la.kind == 1) {
			name = Ident();
			SymbolTable s = syms; 
			if (la.kind == 12) {
				Get();
				Symbol cmp = s.find(name);
				if (cmp == null || !(cmp.type instanceof ComponentTy))
				   SemErr("No component " + name + " imported");
				else s = ((ComponentTy)cmp.type).syms;
				unknwnOk = false;
				
				name = Ident();
			}
			Symbol e = s.find(name);
			if (e == null && !unknwnOk)
			   SemErr("Type " + name + " not declared");
			else if (e == null)
			   ty = new UnknownType(s, name);                
			else if (e.kind != Kind.TYPENAME && e.kind != Kind.COMPNAME)
			   SemErr(name + " is not a type");
			else {
			   ty = e.type;
			}
			
		} else SynErr(84);
		return ty;
	}

	void VarDcl(SymbolTable syms, SymbolTable tysyms, boolean readonly, Kind k, boolean unknwnOk) {
		String name;
		DataType ty;
		
		ty = Type(tysyms, unknwnOk);
		name = Ident();
		ty = ty.resolveType();  
		if (!syms.insert(name, ty, readonly, k)) 
		   SemErr("Multiple Declaration of " + name);
		
		while (la.kind == 27) {
			Get();
			name = Ident();
			if (!syms.insert(name, ty, readonly, k)) 
			  SemErr("Multiple Declaration of " + name);
			
		}
	}

	void StaticDclrand(DataType ty, SymbolTable syms, Kind k) {
		String name;
		TypedAST ast = null; 
		ty = ty.resolveType();
		
		name = Ident();
		if (la.kind == 28) {
			Get();
			Expect(29);
			ast = Reference(syms);
			k = Kind.COMPVAR; 
		}
		if (!syms.insert(name, ty, ast, false, k))
		  SemErr("Multiple Declaration of " + name);
		
	}

	TypedAST  Reference(SymbolTable scope) {
		TypedAST  ast;
		ast = null; 
		switch (la.kind) {
		case 1: {
			ast = SimpleRef(scope);
			while (la.kind == 12) {
				Get();
				TypedAST qual; 
				qual = SimpleRef(scope);
				ast = new QualAST(t.line, t.col, ast, qual); 
			}
			break;
		}
		case 69: case 70: {
			boolean earliest = true; 
			if (la.kind == 69) {
				Get();
			} else {
				Get();
				earliest = false; 
			}
			TypedAST tsAst;
			LinkedList<TypedAST> TStamps = new LinkedList<TypedAST>();
			
			Expect(31);
			tsAst = Expr(scope);
			TStamps.add(tsAst); 
			while (la.kind == 27) {
				Get();
				tsAst = Expr(scope);
				TStamps.add(tsAst); 
			}
			Expect(32);
			ast = new ExtremeTsAST(t.line, t.col, earliest, TStamps); 
			break;
		}
		case 71: {
			Get();
			TypedAST ts1, ts2; 
			Expect(31);
			ts1 = Expr(scope);
			Expect(27);
			ts2 = Expr(scope);
			Expect(32);
			ast = new BinaryOpAST(t.line, t.col, Operators.DURATION, ts1, ts2); 
			break;
		}
		case 72: {
			Get();
			ast = new ConstTsAST(t.line, t.col, Integer.MIN_VALUE); 
			break;
		}
		case 73: {
			Get();
			ast = new ConstTsAST(t.line, t.col, Integer.MAX_VALUE); 
			break;
		}
		case 16: {
			Get();
			TypedAST fAst; 
			Expect(31);
			fAst = Expr(scope);
			ast = new toIntegerAST(t.line, t.col, fAst); 
			Expect(32);
			break;
		}
		default: SynErr(85); break;
		}
		return ast;
	}

	int  Fparams(SymbolTable syms) {
		int  parcnt;
		FormalPar(syms);
		parcnt = 1; 
		while (la.kind == 27) {
			Get();
			FormalPar(syms);
			parcnt++; 
		}
		return parcnt;
	}

	void FormalPar(SymbolTable syms) {
		String name;
		DataType ty;
		
		Kind k = Kind.LOCALVAR;
		
		if (la.kind == 9) {
			Get();
			k = Kind.VARPAR;
			
		}
		ty = Type(syms.outer, false);
		name = Ident();
		if (!syms.insert(name, ty.resolveType(), false, k))
		  SemErr("Multiple Declaration of " + name);
		
	}

	AST  Statement(SymbolTable scope) {
		AST  ast;
		ast = null; 
		switch (la.kind) {
		case 37: {
			ast = IfStmnt(scope);
			break;
		}
		case 41: {
			ast = ForStmnt(scope);
			break;
		}
		case 25: {
			ast = TuppleAssignment(scope);
			break;
		}
		case 1: {
			ast = AssignmentOrProcCall(scope);
			break;
		}
		case 45: {
			ast = ReturnStmnt(scope);
			break;
		}
		case 46: {
			ast = TryStmnt(scope);
			break;
		}
		case 48: {
			ast = ThrowStmnt();
			break;
		}
		default: SynErr(86); break;
		}
		return ast;
	}

	IfAST  IfStmnt(SymbolTable scope) {
		IfAST  ast;
		TypedAST cond;
		SequenceAST alt; 
		
		Expect(37);
		cond = Expr(scope);
		Expect(38);
		alt = StmntList(scope);
		ast = new IfAST(t.line, t.col, cond, alt); 
		while (la.kind == 39) {
			Get();
			cond = Expr(scope);
			Expect(38);
			alt = StmntList(scope);
			ast.addElsIf(cond, alt); 
		}
		if (la.kind == 40) {
			Get();
			alt = StmntList(scope);
			ast.addElse(alt); 
		}
		Expect(11);
		return ast;
	}

	ForAST  ForStmnt(SymbolTable scope) {
		ForAST  ast;
		String name;
		TypedAST init, term, inc = new ConstIntAST(t.line, t.col, 1);
		SequenceAST body;
		SymbolTable bodyScope;
		boolean dwn = false; 
		
		Expect(41);
		name = Ident();
		bodyScope = new SymbolTable(scope);
		if (!bodyScope.insert(name, new IntegerType(), true, Kind.LOCALVAR)) 
		   throw new FatalError("cannot declare loop variable");
		
		Expect(14);
		init = AExpr(scope);
		if (la.kind == 29) {
			Get();
		} else if (la.kind == 42) {
			Get();
			dwn = true; 
		} else SynErr(87);
		term = AExpr(scope);
		if (la.kind == 43) {
			Get();
			inc = AExpr(scope);
		}
		Expect(44);
		body = StmntList(bodyScope);
		Expect(11);
		ast = new ForAST(t.line, t.col, bodyScope, init, term, inc, dwn, body); 
		return ast;
	}

	AssignmentAST  TuppleAssignment(SymbolTable scope) {
		AssignmentAST  ast;
		String name, qual = null;
		ActParsAST pAst = null;
		LhsTuppleAST lhs;
		TypedAST rhs = null;
		
		lhs = RefTupple(scope);
		Expect(14);
		if (la.kind == 25) {
			rhs = Tupple(scope);
		} else if (la.kind == 1) {
			name = Ident();
			if (la.kind == 12) {
				Get();
				qual = Ident();
			}
			Expect(31);
			if (StartOf(4)) {
				pAst = AParams(scope);
			}
			Expect(32);
			if (qual == null) {
			  RefAST rAst = new RefAST(t.line, t.col, scope, name);
			  rhs = new FunCallAST(t.line, t.col, rAst, pAst);
			} else {
			   RefAST base = new RefAST(t.line, t.col, scope, name);
			   RefAST q = new RefAST(t.line, t.col, null, qual);
			   FunCallAST fun = new FunCallAST(t.line, t.col, q, pAst);
			   rhs = new QualAST(t.line, t.col, base, fun);
			}  
			
		} else SynErr(88);
		ast = new AssignmentAST(t.line, t.col, lhs, rhs); 
		return ast;
	}

	AST  AssignmentOrProcCall(SymbolTable scope) {
		AST  stmnt;
		String name, qual; 
		TypedAST ast, iast;
		ActParsAST pAst = null;
		TypedAST lhs = null;
		stmnt = null;
		
		name = Ident();
		if (la.kind == 31) {
			Get();
			if (StartOf(4)) {
				pAst = AParams(scope);
			}
			Expect(32);
			stmnt = new ProcCallAST(t.line, t.col, name, scope, pAst); 
		} else if (StartOf(5)) {
			iast = null; 
			if (la.kind == 25) {
				Get();
				iast = AExpr(scope);
				Expect(26);
			}
			if (stmnt == null) lhs = new LhsAST(t.line, t.col, name, scope, iast); 
		} else SynErr(89);
		while (la.kind == 12) {
			Get();
			qual = Ident();
			if (la.kind == 31) {
				Get();
				if (StartOf(4)) {
					pAst = AParams(scope);
				}
				Expect(32);
				if (stmnt == null) 
				  stmnt = new ComponentCallAST(t.line, t.col, scope, name, qual, pAst);
				else 
				   SemErr("invalid component call");
				
			} else if (StartOf(5)) {
				iast = null; 
				if (la.kind == 25) {
					Get();
					iast = AExpr(scope);
					Expect(26);
				}
				lhs = new LhsQualAST(t.line, t.col, lhs, qual, iast); 
			} else SynErr(90);
		}
		if (la.kind == 14) {
			Get();
			ast = Expr(scope);
			if (stmnt == null) 
			  stmnt = new AssignmentAST(t.line, t.col, lhs, ast);   
			else 
			   SemErr("invalid assignment");
			
		}
		return stmnt;
	}

	ReturnAST  ReturnStmnt(SymbolTable scope) {
		ReturnAST  ast;
		TypedAST ret = null; 
		Expect(45);
		if (StartOf(6)) {
			if (StartOf(4)) {
				ret = Expr(scope);
			} else {
				ret = Tupple(scope);
			}
		}
		ast = new ReturnAST(t.line, t.col, ret); 
		return ast;
	}

	TryAST  TryStmnt(SymbolTable scope) {
		TryAST  ast;
		SequenceAST tryBody, catchBody; 
		Expect(46);
		tryBody = StmntList(scope);
		Expect(47);
		catchBody = StmntList(scope);
		Expect(11);
		ast = new TryAST(t.line, t.col, tryBody, catchBody); 
		return ast;
	}

	ThrowAST  ThrowStmnt() {
		ThrowAST  ast;
		Expect(48);
		Expect(4);
		ast = new ThrowAST(t.line, t.col, t.val); 
		return ast;
	}

	TypedAST  AExpr(SymbolTable scope) {
		TypedAST  ast;
		TypedAST sndAst; 
		ast = ATerm(scope);
		while (StartOf(7)) {
			if (la.kind == 59) {
				Get();
				sndAst = ATerm(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.ADD, ast, sndAst); 
			} else if (la.kind == 60) {
				Get();
				sndAst = ATerm(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.SUB, ast, sndAst); 
			} else if (la.kind == 61) {
				Get();
				sndAst = ATerm(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.BITOR, ast, sndAst); 
			} else {
				Get();
				sndAst = ATerm(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.BITXOR, ast, sndAst); 
			}
		}
		return ast;
	}

	LhsTuppleAST  RefTupple(SymbolTable scope) {
		LhsTuppleAST  refTupple;
		TypedAST ast;
		refTupple = new LhsTuppleAST(t.line, t.col); 
		
		Expect(25);
		ast = Reference(scope);
		refTupple.append(ast); 
		while (la.kind == 27) {
			Get();
			ast = Reference(scope);
			refTupple.append(ast); 
		}
		Expect(26);
		return refTupple;
	}

	TuppleAST  Tupple(SymbolTable scope) {
		TuppleAST  tupple;
		TypedAST ast;
		tupple = new TuppleAST(t.line, t.col); 
		
		Expect(25);
		ast = Expr(scope);
		tupple.append(ast); 
		while (la.kind == 27) {
			Get();
			ast = Expr(scope);
			tupple.append(ast); 
		}
		Expect(26);
		return tupple;
	}

	ActParsAST  AParams(SymbolTable scope) {
		ActParsAST  ast;
		TypedAST pAst;
		ast = null; 
		
		pAst = Expr(scope);
		ast = new ActParsAST(t.line, t.col, pAst); 
		while (la.kind == 27) {
			Get();
			pAst = Expr(scope);
			ast.append(pAst); 
		}
		return ast;
	}

	TypedAST  Term(SymbolTable scope) {
		TypedAST  ast;
		TypedAST sndAst; 
		ast = Factor(scope);
		while (la.kind == 50) {
			Get();
			sndAst = Factor(scope);
			ast = new BinaryOpAST(t.line, t.col, Operators.AND, ast, sndAst); 
		}
		return ast;
	}

	TypedAST  Factor(SymbolTable scope) {
		TypedAST  ast;
		TypedAST sndAst;
		boolean invert = false;
		ast = null;
		
		if (la.kind == 51) {
			Get();
			invert = true; 
		}
		if (StartOf(8)) {
			ast = AExpr(scope);
			if (StartOf(9)) {
				switch (la.kind) {
				case 52: {
					Get();
					sndAst = AExpr(scope);
					ast = new BinaryOpAST(t.line, t.col, Operators.LESS, ast, sndAst); 
					break;
				}
				case 53: {
					Get();
					sndAst = AExpr(scope);
					ast = new BinaryOpAST(t.line, t.col, Operators.LESSEQUAL, ast, sndAst); 
					break;
				}
				case 15: {
					Get();
					sndAst = AExpr(scope);
					ast = new BinaryOpAST(t.line, t.col, Operators.EQUAL, ast, sndAst); 
					break;
				}
				case 54: {
					Get();
					sndAst = AExpr(scope);
					ast = new BinaryOpAST(t.line, t.col, Operators.GREATEREQUAL, ast, sndAst); 
					break;
				}
				case 55: {
					Get();
					sndAst = AExpr(scope);
					ast = new BinaryOpAST(t.line, t.col, Operators.GREATER, ast, sndAst); 
					break;
				}
				case 56: {
					Get();
					sndAst = AExpr(scope);
					ast = new BinaryOpAST(t.line, t.col, Operators.UNEQUAL, ast, sndAst); 
					break;
				}
				}
			}
		} else if (la.kind == 57) {
			Get();
			ast = new ConstBoolAST(t.line, t.col, true); 
		} else if (la.kind == 58) {
			Get();
			ast = new ConstBoolAST(t.line, t.col, false); 
		} else SynErr(91);
		if (invert) ast = new UnaryOpAST(t.line, t.col, Operators.NOT, ast); 
		return ast;
	}

	TypedAST  ATerm(SymbolTable scope) {
		TypedAST  ast;
		TypedAST sndAst; 
		ast = AFactor(scope);
		while (StartOf(10)) {
			if (la.kind == 63) {
				Get();
				sndAst = AFactor(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.MUL, ast, sndAst); 
			} else if (la.kind == 64) {
				Get();
				sndAst = AFactor(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.DIV, ast, sndAst); 
			} else if (la.kind == 65) {
				Get();
				sndAst = AFactor(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.IDIV, ast, sndAst); 
			} else if (la.kind == 66) {
				Get();
				sndAst = AFactor(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.MOD, ast, sndAst); 
			} else {
				Get();
				sndAst = AFactor(scope);
				ast = new BinaryOpAST(t.line, t.col, Operators.BITAND, ast, sndAst); 
			}
		}
		return ast;
	}

	TypedAST  AFactor(SymbolTable syms) {
		TypedAST  ast;
		boolean chngSign = false, invert = false; 
		ast = null;
		
		if (la.kind == 60 || la.kind == 68) {
			if (la.kind == 60) {
				Get();
				chngSign = true; 
			} else {
				Get();
				invert = true; 
			}
		}
		if (la.kind == 31) {
			Get();
			ast = Expr(syms);
			Expect(32);
		} else if (la.kind == 2) {
			ast = Number();
		} else if (la.kind == 3) {
			ast = Float();
		} else if (la.kind == 4) {
			ast = String();
		} else if (StartOf(11)) {
			ast = Reference(syms);
		} else SynErr(92);
		if (chngSign) ast = new UnaryOpAST(t.line, t.col, Operators.MINUS, ast);
		else if (invert) ast = new UnaryOpAST(t.line, t.col, Operators.INVERT, ast);
		
		return ast;
	}

	ConstIntAST  Number() {
		ConstIntAST  ast;
		Expect(2);
		ast = new ConstIntAST(t.line, t.col, new Integer(t.val)); 
		return ast;
	}

	ConstFloatAST  Float() {
		ConstFloatAST  ast;
		Expect(3);
		ast = new ConstFloatAST(t.line, t.col, new Float(t.val)); 
		return ast;
	}

	ConstStringAST  String() {
		ConstStringAST  ast;
		Expect(4);
		ast = new ConstStringAST(t.line, t.col, new String(t.val)); 
		return ast;
	}

	TypedAST  SimpleRef(SymbolTable scope) {
		TypedAST  ast;
		String name;
		RefAST RAst;
		TypedAST iAst;
		
		name = Ident();
		ast = RAst = new RefAST(t.line, t.col, scope, name); 
		if (la.kind == 31) {
			Get();
			ActParsAST pAst = null; 
			if (StartOf(4)) {
				pAst = AParams(scope);
			}
			Expect(32);
			ast = new FunCallAST(t.line, t.col, RAst, pAst); 
		}
		if (la.kind == 25) {
			Get();
			iAst = AExpr(scope);
			Expect(26);
			ast = new ArrayRefAST(t.line, t.col, ast, iAst); 
		}
		return ast;
	}

	void ObjVarDcl(SymbolTable syms) {
		boolean readonly = false; 
		if (la.kind == 76) {
			Get();
			readonly = true; 
		}
		VarDcl(syms, syms, readonly, Kind.COMPVAR, false);
	}

	void EventDcl(SymbolTable outer) {
		String name;
		TypedAST ast = new ConstIntAST(1);
		
		if (la.kind == 24) {
			Get();
			Expect(25);
			ast = Expr(outer);
			Expect(26);
			Expect(23);
		}
		Expect(77);
		name = Ident();
		SymbolTable eventSyms = new SymbolTable(outer); 
		if (StartOf(2)) {
			VarDcl(eventSyms, outer, true, Kind.STATICVAR, false);
			while (la.kind == 6) {
				Get();
				VarDcl(eventSyms, outer, true, Kind.STATICVAR, false);
			}
		}
		Expect(11);
		EventType event = new EventType(eventSyms, ast);
		if (!outer.insert(name, event.resolveType(), false, Kind.EVENTNAME))
		SemErr("Multiple Declaration of " + name);  
		
	}

	void ProcInterfaceDcl(SymbolTable outer, int procNo) {
		String name;
		DataType retType = null;
		int parcnt = 0;
		
		Expect(30);
		name = Ident();
		SymbolTable parSyms = new SymbolTable(outer);
		
		Expect(31);
		if (StartOf(1)) {
			parcnt = Fparams(parSyms);
		}
		Expect(32);
		if (la.kind == 33) {
			Get();
			if (StartOf(2)) {
				retType = Type(outer, false);
			} else if (la.kind == 25) {
				Get();
				DataType ty;
				LinkedList<DataType>compTypes = new LinkedList<DataType>();
				
				ty = Type(outer, false);
				compTypes.addLast(ty); 
				while (la.kind == 27) {
					Get();
					ty = Type(outer, false);
					compTypes.addLast(ty); 
				}
				retType = new TuppleType(compTypes); 
				Expect(26);
			} else SynErr(93);
		}
		parSyms.allocateMemory(true, parcnt);
		ProcType proc = new ProcType(parSyms, parcnt, retType, procNo);
		// System.out.println("procNo = " + procNo);
		if (!outer.insert(name, proc.resolveType(), false, Kind.PROCNAME))
		   SemErr("Multiple Declaration of " + name);
		
	}



	public void Parse() {
		la = new Token();
		la.val = "";		
		Get();
		Stamped();

		Expect(0);
	}

	private static final boolean[][] set = {
		{T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x},
		{x,T,x,x, x,x,x,x, x,T,x,x, x,x,x,x, T,T,T,T, T,T,T,x, T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x},
		{x,T,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,T,T,T, T,T,T,x, T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x},
		{x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,T,T,T, T,T,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x},
		{x,T,T,T, T,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, x,x,x,x, x,T,T,x, T,x,x,x, x,x,x,x, T,T,T,T, T,T,x,x, x,x,x,x},
		{x,x,x,x, x,x,T,x, x,x,x,T, T,x,T,x, x,x,x,x, x,x,x,x, x,T,x,x, x,x,x,x, x,x,x,x, x,x,x,T, T,x,x,x, x,x,x,T, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x},
		{x,T,T,T, T,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x,x,x, x,T,x,x, x,x,x,T, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, x,x,x,x, x,T,T,x, T,x,x,x, x,x,x,x, T,T,T,T, T,T,x,x, x,x,x,x},
		{x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, T,T,T,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x},
		{x,T,T,T, T,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x,x,x, T,T,T,T, T,T,x,x, x,x,x,x},
		{x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,T,T,T, T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x},
		{x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, T,T,T,T, x,x,x,x, x,x,x,x, x,x,x,x},
		{x,T,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,T,T,T, T,T,x,x, x,x,x,x}

	};
} // end Parser


class Errors {
	public int count = 0;                                    // number of errors detected
	public java.io.PrintStream errorStream = System.out;     // error messages go to this stream
	public String errMsgFormat = "-- line {0} col {1}: {2}"; // 0=line, 1=column, 2=text
	
	protected void printMsg(int line, int column, String msg) {
		StringBuffer b = new StringBuffer(errMsgFormat);
		int pos = b.indexOf("{0}");
		if (pos >= 0) { b.delete(pos, pos+3); b.insert(pos, line); }
		pos = b.indexOf("{1}");
		if (pos >= 0) { b.delete(pos, pos+3); b.insert(pos, column); }
		pos = b.indexOf("{2}");
		if (pos >= 0) b.replace(pos, pos+3, msg);
		errorStream.println(b.toString());
	}
	
	public void SynErr (int line, int col, int n) {
		String s;
		switch (n) {
			case 0: s = "EOF expected"; break;
			case 1: s = "ident expected"; break;
			case 2: s = "number expected"; break;
			case 3: s = "float expected"; break;
			case 4: s = "string expected"; break;
			case 5: s = "\"PROGRAM\" expected"; break;
			case 6: s = "\";\" expected"; break;
			case 7: s = "\"CONST\" expected"; break;
			case 8: s = "\"TYPE\" expected"; break;
			case 9: s = "\"VAR\" expected"; break;
			case 10: s = "\"BEGIN\" expected"; break;
			case 11: s = "\"END\" expected"; break;
			case 12: s = "\".\" expected"; break;
			case 13: s = "\"IMPORT\" expected"; break;
			case 14: s = "\":=\" expected"; break;
			case 15: s = "\"=\" expected"; break;
			case 16: s = "\"INTEGER\" expected"; break;
			case 17: s = "\"FLOAT\" expected"; break;
			case 18: s = "\"BOOL\" expected"; break;
			case 19: s = "\"BLOB\" expected"; break;
			case 20: s = "\"TIMESTAMP\" expected"; break;
			case 21: s = "\"STRING\" expected"; break;
			case 22: s = "\"RECORD\" expected"; break;
			case 23: s = "\"OF\" expected"; break;
			case 24: s = "\"ARRAY\" expected"; break;
			case 25: s = "\"[\" expected"; break;
			case 26: s = "\"]\" expected"; break;
			case 27: s = "\",\" expected"; break;
			case 28: s = "\"MAP\" expected"; break;
			case 29: s = "\"TO\" expected"; break;
			case 30: s = "\"PROCEDURE\" expected"; break;
			case 31: s = "\"(\" expected"; break;
			case 32: s = "\")\" expected"; break;
			case 33: s = "\":\" expected"; break;
			case 34: s = "\"TASK\" expected"; break;
			case 35: s = "\"PERIODIC\" expected"; break;
			case 36: s = "\"ON\" expected"; break;
			case 37: s = "\"IF\" expected"; break;
			case 38: s = "\"THEN\" expected"; break;
			case 39: s = "\"ELSIF\" expected"; break;
			case 40: s = "\"ELSE\" expected"; break;
			case 41: s = "\"FOR\" expected"; break;
			case 42: s = "\"DOWNTO\" expected"; break;
			case 43: s = "\"BY\" expected"; break;
			case 44: s = "\"DO\" expected"; break;
			case 45: s = "\"RETURN\" expected"; break;
			case 46: s = "\"TRY\" expected"; break;
			case 47: s = "\"CATCH\" expected"; break;
			case 48: s = "\"THROW\" expected"; break;
			case 49: s = "\"OR\" expected"; break;
			case 50: s = "\"AND\" expected"; break;
			case 51: s = "\"NOT\" expected"; break;
			case 52: s = "\"<\" expected"; break;
			case 53: s = "\"<=\" expected"; break;
			case 54: s = "\">=\" expected"; break;
			case 55: s = "\">\" expected"; break;
			case 56: s = "\"#\" expected"; break;
			case 57: s = "\"TRUE\" expected"; break;
			case 58: s = "\"FALSE\" expected"; break;
			case 59: s = "\"+\" expected"; break;
			case 60: s = "\"-\" expected"; break;
			case 61: s = "\"|\" expected"; break;
			case 62: s = "\"^\" expected"; break;
			case 63: s = "\"*\" expected"; break;
			case 64: s = "\"/\" expected"; break;
			case 65: s = "\"DIV\" expected"; break;
			case 66: s = "\"MOD\" expected"; break;
			case 67: s = "\"&\" expected"; break;
			case 68: s = "\"~\" expected"; break;
			case 69: s = "\"EARLIEST\" expected"; break;
			case 70: s = "\"LATEST\" expected"; break;
			case 71: s = "\"DURATION\" expected"; break;
			case 72: s = "\"BOT\" expected"; break;
			case 73: s = "\"EOT\" expected"; break;
			case 74: s = "\"COMPONENT\" expected"; break;
			case 75: s = "\"OBJECTDICTIONARY\" expected"; break;
			case 76: s = "\"READONLY\" expected"; break;
			case 77: s = "\"EVENT\" expected"; break;
			case 78: s = "??? expected"; break;
			case 79: s = "invalid CompilationUnit"; break;
			case 80: s = "invalid ProcDcl"; break;
			case 81: s = "invalid TaskDcl"; break;
			case 82: s = "invalid Type"; break;
			case 83: s = "invalid SimpleType"; break;
			case 84: s = "invalid CompoundType"; break;
			case 85: s = "invalid Reference"; break;
			case 86: s = "invalid Statement"; break;
			case 87: s = "invalid ForStmnt"; break;
			case 88: s = "invalid TuppleAssignment"; break;
			case 89: s = "invalid AssignmentOrProcCall"; break;
			case 90: s = "invalid AssignmentOrProcCall"; break;
			case 91: s = "invalid Factor"; break;
			case 92: s = "invalid AFactor"; break;
			case 93: s = "invalid ProcInterfaceDcl"; break;
			default: s = "error " + n; break;
		}
		printMsg(line, col, s);
		count++;
	}

	public void SemErr (int line, int col, String s) {	
		printMsg(line, col, s);
		count++;
	}
	
	public void SemErr (String s) {
		errorStream.println(s);
		count++;
	}
	
	public void Warning (int line, int col, String s) {	
		printMsg(line, col, s);
	}
	
	public void Warning (String s) {
		errorStream.println(s);
	}
} // Errors


class FatalError extends RuntimeException {
	public static final long serialVersionUID = 1L;
	public FatalError(String s) { super(s); }
}

