package IRed.spectro.stamped;

public class ProcCallAST extends AST {
   String name;
   SymbolTable scope;      
   ActParsAST params;
   private Symbol proc;

   public ProcCallAST(int line, int col, String name, SymbolTable scope, ActParsAST params) {
      super(line, col);
      this.name = name;
      this.scope = scope;
      this.params = params;
      proc = null;
   }

   public boolean distributeTypes(boolean isFunBody) {
      proc = scope.find(name);
      if (proc == null || !(proc.type instanceof ProcType)) {
         SemErr("PROCEDURE not declared");
         return false;
      }
      ProcType ty = (ProcType)proc.type;
      if (ty.retType != null) {
         SemErr("PROCEDURE returns value");
         return false;
      }
      if (params == null) {
         if (ty.parcnt != 0) {
            SemErr("wrong number of arguments in call");
            return false;
         } 
         return true;
      } else if (!params.distributeTypes()) return false;
      return params.checkTypes(ty.parcnt, ty.locals);
   }

   public void generateCode(boolean isTry) {
      ProcType ty = (ProcType)proc.type;
      // System.out.println("in ProcCallAST.generateCode");
      if (params != null) params.move2Stack(ty.parcnt, ty.locals);
      Compiler.code.Emit(Instruction.CALL, ty.label, "");
      // System.out.println("out ProcCallAST.generateCode");
   }

   public void dump(String left) {
      System.out.println(left + "procedure call");
      if (params != null) params.dump(left + "   ");
   }

}
