package IRed.spectro.stamped;

import java.io.DataOutputStream;
import java.io.IOException;

public class ProcType extends DataType {
   SymbolTable locals;
   int parcnt;
   DataType retType;
   AST body;
   Code.Label label;
   int procNo;

	public ProcType (SymbolTable locals, int parcnt, DataType retType, AST body) {
		super(0);
      this.locals = locals; this.parcnt = parcnt;
      this.retType = retType;
      this.label = ((body == null) ? null : Compiler.code.genLabel());
      this.body = body;
      this.procNo = 0;
	}

	public ProcType (SymbolTable locals, int parcnt, DataType retType, int procNo) {
		super(0);
      this.locals = locals; this.parcnt = parcnt;
      this.retType = retType;
      this.label = null;
      this.body = null;
      this.procNo = procNo;
	}

	public boolean assignable(DataType rhs) {
		return false;
	}

	public DataType clone() {
		return this;               // pointless to clone
	}

   public boolean equals(Object o) {
      return false;
   }

	public DataType resolveType() {
      // System.out.println("resolving ProcType, resolved = " + resolved);
      if (!resolved) {
         // System.out.println("resolving ProcType");
         if (!locals.resolveTypes()) Compiler.parser.SemErr("Unable to resolve types");
         if (retType != null) {
            retType = retType.resolveType();
            // retType.dump("resolved returntype = ");
         }
         resolved = true;
      }
      return this;
   }

	public void dump(String left) {
		System.out.println(left + "Procedure");
	}

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(Tag.PROCEDURE);
      out.writeInt(parcnt);
      for (Symbol s: locals.table.values()) s.type.dumpBinary(out);
      if (retType != null) retType.dumpBinary(out);
      else out.writeInt(Tag.NOTYPE);
   }

}
