package IRed.spectro.stamped;

import java.util.List;

public class QualAST extends TypedAST {
	TypedAST base;
	TypedAST qual;	
   Symbol compFun;

	public QualAST(int line, int col, TypedAST base, TypedAST qual) {
		super(line, col, null);
		this.base = base; this.qual = qual; compFun = null;
	}

	public TypedAST resolveConst() {
		TypedAST q = qual.resolveConst();
      if ((base.getType() instanceof ComponentTy) && q.isConst()) return q;
      else return this;
	}

   public boolean distributeTypes(boolean isFunBody) {
      // System.out.println("in QualAST distributeTypes");
      if (!base.distributeTypes()) return false;
      // do not distribute types over the qualification, we need the name only!!!

      SymbolTable baseSyms;
      DataType baseType = base.getType();
      if (baseType instanceof RecordType) {
         baseSyms = ((RecordType)baseType).fields;
      } else if (base.getType() instanceof ComponentTy) {
         baseSyms = ((ComponentTy)baseType).syms;
      } else {
         SemErr("base type is not a RECORD or a COMPONENT");
         return false;
      }
      offset = base.offset;
      kind = base.kind;
      DataType qualType = qual.type;
      if (qual instanceof RefAST && qualType instanceof UnknownType) {
         // a scalar field
         Symbol s = ((RefAST)qual).sym = baseSyms.find(((UnknownType)qualType).name);
         if (s == null) {
            SemErr("invalid RECORD or COMPONENT qualifier");
           return false;
         }
         type = qual.type = s.type = s.type.resolveType();
         if (!s.mapped) throw new FatalError("record has not been mapped");
         qual.offset = s.offset;
         readOnly = qual.readOnly = s.readOnly;
         qual.kind = s.kind;
      } else if (qual instanceof ArrayRefAST) {
         // an array field   
         ArrayRefAST arrayRef = (ArrayRefAST)qual;
         if (!arrayRef.indexAst.distributeTypes()) return false;
         if (!(arrayRef.indexAst.getType() instanceof IntegerType)) {
            SemErr("index must be an INTEGER");
            return false;
         }
         if (!(arrayRef.arrayVarAst.getType() instanceof UnknownType)) throw new FatalError("internal error in reference");
         String fieldName = ((UnknownType)arrayRef.arrayVarAst.getType()).name;
         Symbol s = baseSyms.find(fieldName);
         if (s == null) {
            SemErr("invalid RECORD or COMPONENT qualifier");
            return false;
         }
         if (!(s.type instanceof ArrayType)) {
            SemErr("not an ARRAY");
            return false;
         }
         if (!s.mapped) throw new FatalError("record has not been mapped");
         arrayRef.arrayVarAst.type = s.type; arrayRef.kind = arrayRef.arrayVarAst.kind = s.kind; arrayRef.arrayVarAst.offset = s.offset;
         arrayRef.valid = valid;
         
         type = arrayRef.type = ((ArrayType)s.type).getBasicType();
      } else if (baseType instanceof ComponentTy && qual instanceof FunCallAST) {
         // a component function call
         FunCallAST fun = (FunCallAST)qual;
         if (!(fun.funName.getType() instanceof UnknownType)) {
            throw new FatalError("internal error in reference");
         }
         String fieldName = ((UnknownType)fun.funName.getType()).name;
         compFun = baseSyms.find(fieldName);
         if (compFun == null || !(compFun.type instanceof ProcType)) {
            // System.out.println("in QualAST DistributeTypes: fieldname = " + fieldName);
            // compFun.dump("in QualAST compFun = ");
            SemErr("not declared as PROCEDURE");
            return false;
         }
         fun.type = compFun.type;
         ProcType ptype = (ProcType)compFun.type;
         if (fun.params == null) {
            if (ptype.parcnt != 0) {
               SemErr("wrong number of arguments in call");
               return false;
            }
         } else {
            if (!fun.params.distributeTypes()) return false;   
            if (fun.params != null && !fun.params.checkTypes(ptype.parcnt, ptype.locals)) return false;
         }
         type = fun.type = ptype.retType;
         if (type == null) {
            SemErr("COMPONENT PROCEDURE does not return value");
            return false;
         }
      } else {
         throw new FatalError("internal error, problem with qualifier");
      }
      // System.out.println("out QualAST distributeTypes");
      return valid = true;
   }

   public TypedAST moveVal2Stack() {
      TypedAST res = resolveConst();
      if (res != this) return res;
      // System.out.println("in QualAST.moveVal2Stack");
      if (base.getType() instanceof ComponentTy && qual instanceof FunCallAST) {
         FunCallAST fun = (FunCallAST)qual;
         ProcType ptype = (ProcType)compFun.type;
         if (fun.params != null) fun.params.move2Stack(ptype.parcnt, ptype.locals);
         if (!(base instanceof RefAST)) throw new FatalError("internal error, problem with base");
         Compiler.code.Emit(Instruction.LOAD, ((RefAST)base).sym.offset, false, "");
         Compiler.code.Emit(Instruction.COMPCALL, ptype.procNo, "");
         place = Place.VALONSTACK;
         return this;
      }
      moveAddr2Stack();
      // System.out.println("QualAST.moveVal2Stack, place = " + place + ", kind = " + kind);
      if (place == Place.VALONSTACK) {
         // System.out.println("out QualAST.moveVal2Stack, place = " + place);
         return this;
      }
      int s = type.size;
      if (place == Place.ADDRONSTACK) {
         if (s == 1) Compiler.code.Emit(Instruction.LOADV, isBlob(), "address on stack");
         else Compiler.code.Emit(Instruction.LOADMV, s, type.getBlobOffsets(0), "address on stack");
         place = Place.VALONSTACK;            
      } else if (place == Place.CONSTADDR) {
         if (kind == Kind.STATICVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOAD, offset, isBlob(), "static variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, false, false, type.getBlobOffsets(0), "static variable");
            place = Place.VALONSTACK;
         } else if (kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOAD, offset, isBlob(), "shared or component variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, false, true, type.getBlobOffsets(0), "shared or component variable");
            place = Place.VALONSTACK;
         } else if (kind == Kind.LOCALVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOADL, offset, isBlob(), "local variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, true, false, type.getBlobOffsets(0), "local variable");
            place = Place.VALONSTACK;
         }
      } else if (place == Place.INDEXONSTACK) {
         int no = ((ArrayType)((ArrayRefAST)qual).arrayVarAst.getType()).no;
         if (kind == Kind.STATICVAR || kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) {
            if (s == 1) {
               Compiler.code.Emit(Instruction.LOADA, offset, no, isBlob(), "static, shared or component variable");
            } else {
               Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(offset), false, "static, shared or component variable, offset: " + offset);
               Compiler.code.Emit(Instruction.ADD, "");
               Compiler.code.Emit(Instruction.LOADMV, s, type.getBlobOffsets(0), "");
            }
            place = Place.VALONSTACK;
         } else if (kind == Kind.LOCALVAR) {
            if (s == 1) {
               Compiler.code.Emit(Instruction.LOADAL, offset, no, isBlob(), "local variable");
            } else {
               Compiler.code.Emit(Instruction.ADDFP, offset, "local variable");
               Compiler.code.Emit(Instruction.ADD, "");
               Compiler.code.Emit(Instruction.LOADMV, s, type.getBlobOffsets(0), "");
            }
            place = Place.VALONSTACK;
         }
      }
      // System.out.println("out QualAST.moveVal2Stack, place = " + place);
      return this;
   }

   public void forceVal2Stack() {
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      // System.out.println("in QualAST.moveVal2Stack");
      int o = offset, s = type.size;
      // System.out.println("QualAST.qualifyOnStack, size = " + s);
      // type.dump("QualAST.type = ");
      Compiler.code.Emit(Instruction.XTRACT, baseSize, o, s, blobLst, ""); 
      qual.qualifyOnStack(s, type.getBlobOffsets(0));
      place = Place.VALONSTACK;
      // System.out.println("out QualAST.moveVal2Stack, place = " + place);      
   }

   public void moveAddr2Stack(boolean check) {
      // System.out.println("in QualAST.moveAddr2Stack");
      base.moveAddr2Stack();
      // System.out.println("QualAST.moveAddr2Stack, base.place = " + base.place + " base.kind = " + base.kind + " base.offset = " + base.offset);
      if (base.place == Place.INDEXONSTACK) {
         int o = base.offset;
         if (kind == Kind.LOCALVAR) {
            Compiler.code.Emit(Instruction.ADDFP, o, "local address");
            Compiler.code.Emit(Instruction.ADD, "");
         } else if (o != 0) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o), false, "base address of structure reference, " + o);
            Compiler.code.Emit(Instruction.ADD, "");
         }
         base.place = Place.ADDRONSTACK;
      }
      // System.out.println("QualAST.moveAddr2Stack, base.place = " + base.place + " base.kind = " + base.kind + " base.offset = " + base.offset);
      if (base.place == Place.VALONSTACK) {
         qual.qualifyOnStack(base.type.size, base.type.getBlobOffsets(0));
         place = qual.place;
         // System.out.println("out QualAST.moveAddr2Stack, place = " + place);
         return;
      }
      qual.moveAddr2Stack(base.place != Place.CONSTADDR);
      // System.out.println("QualAST.moveAddr2Stack, qual.place = " + qual.place + " qual.kind = " + qual.kind + " qual.offset = " + qual.offset);

      if (base.place == Place.CONSTADDR && qual.place == Place.INDEXONSTACK) {
         offset = base.offset + qual.offset;
         if (base.type instanceof ComponentTy) offset++;
         place = Place.INDEXONSTACK;
      } else if (base.place == Place.CONSTADDR && qual.place == Place.CONSTADDR) {
         offset = base.offset + qual.offset;
         if (base.type instanceof ComponentTy) offset++;
         place = Place.CONSTADDR;
      } else if (base.place == Place.CONSTADDR && qual.place == Place.ADDRONSTACK) {
         int o = base.offset;
         if (base.type instanceof ComponentTy) offset++;
         Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o), false, "base address of structure reference, " + o);
         Compiler.code.Emit(Instruction.ADD, "");
         place = Place.ADDRONSTACK;
      } else if (base.place == Place.ADDRONSTACK && qual.place == Place.CONSTADDR) {
         int o = qual.offset;
         if (o != 0) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o), false, "base address of structure reference, " + o);
            Compiler.code.Emit(Instruction.ADD, "");
         }
         place = Place.ADDRONSTACK;         
      } else if (base.place == Place.ADDRONSTACK && qual.place == Place.ADDRONSTACK) {
         Compiler.code.Emit(Instruction.ADD, "");
         place = Place.ADDRONSTACK;
      } else if (base.place == Place.ADDRONSTACK && qual.place == Place.INDEXONSTACK) {
         if (qual.offset != 0) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(qual.offset), false, "offset of field");
            Compiler.code.Emit(Instruction.ADD, "");
         }
         Compiler.code.Emit(Instruction.ADD, "");
         place = Place.ADDRONSTACK;
      } else {
         throw new FatalError("inconsistent qualifier placement");
      }
      // System.out.println("out QualAST.moveAddr2Stack, place = " + place + ", offset = " + offset);
   }

   public void forceAddr2Stack() {
      // System.out.println("in QualAST.forceAddr2Stack");
      moveAddr2Stack();
      if (place == Place.CONSTADDR) {
         int o = offset;
         if (kind == Kind.STATICVAR) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o), false, "static address");
            place = Place.ADDRONSTACK;
         } else if (kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o | 0x80000000), false, "static address");
            place = Place.ADDRONSTACK;
         } else if (kind == Kind.LOCALVAR) {
           Compiler.code.Emit(Instruction.ADDFP, o, "local address");
           place = Place.ADDRONSTACK;
         }
      }
      // System.out.println("out QualAST.forceAddr2Stack, place = " + place);
   }

	public void dump(String left) {
		System.out.println(left + "Qualifier");
      System.out.println(left + "   offset = " + offset);
		base.dump(left + "   base = ");
		qual.dump(left + "   qual = ");
	}

}
