package IRed.spectro.stamped;

import java.util.Map;
import java.util.Iterator;
import java.util.List;
import java.io.DataOutputStream;
import java.io.IOException;

class RecordType extends DataType {
	SymbolTable fields;

	public RecordType(SymbolTable s) {
		super(0);
		fields = s;
	}

	private RecordType(RecordType orig) {
		super(orig);
		fields = orig.fields;
	}

	public boolean assignable(DataType rhs) {
		if (!(rhs instanceof RecordType)) return false;
		Iterator<Map.Entry<String, Symbol>> 
			lhsFields = fields.table.entrySet().iterator(), 
			rhsFields = ((RecordType)rhs).fields.table.entrySet().iterator();

		while (lhsFields.hasNext() && rhsFields.hasNext()) {
			Map.Entry<String, Symbol> lhsField = lhsFields.next(), rhsField = rhsFields.next();

			if (!lhsField.getKey().equals(rhsField.getKey())) return false;
			if (!lhsField.getValue().type.assignable(rhsField.getValue().type)) return false;			
		}
		if (lhsFields.hasNext() || rhsFields.hasNext()) return false;
		return true;
	}

	public DataType clone() {
		return new RecordType(this);
	}

   public boolean equals(Object o) {
		if (!(o instanceof RecordType)) return false;
      RecordType rhs = (RecordType)o;
		Iterator<Map.Entry<String, Symbol>> 
			lhsFields = fields.table.entrySet().iterator(), 
			rhsFields = rhs.fields.table.entrySet().iterator();

		while (lhsFields.hasNext() && rhsFields.hasNext()) {
			Map.Entry<String, Symbol> lhsField = lhsFields.next(), rhsField = rhsFields.next();

			if (!lhsField.getKey().equals(rhsField.getKey())) return false;
			if (!lhsField.getValue().type.equals(rhsField.getValue().type)) return false;			
		}
		if (lhsFields.hasNext() || rhsFields.hasNext()) return false;
		return true;
   }

	public DataType resolveType() {
		if (!resolved) {
			resolved = true;
			for (Symbol s: fields.table.values()) {
            s.type = s.type.resolveType();
         }
         size = fields.allocateMemory(false, 0);
         // System.out.println("resolving RECORD, size = " + size);
		}
 		return this;
	}

   public List<Integer> getBlobOffsets(int strt) {
      return fields.getBlobOffsets(strt);
   }

	public void dump(String left) {
		System.out.println(left + "Record");
		fields.dump(left + "   ");
	}

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(Tag.RECORD);
      out.writeInt(fields.table.size());
      for (Symbol s: fields.table.values()) s.type.dumpBinary(out);
   }   

}
