package IRed.spectro.stamped;

import java.util.List;

public class RefAST extends TypedAST {
   Symbol sym;

	public RefAST(int line, int col, SymbolTable syms, String n) {
		super(line, col, new UnknownType(syms , n));
      sym = null;
	}

	public TypedAST resolveConst() {
      Symbol s;
      if (type instanceof UnknownType) {
	   	UnknownType ty = (UnknownType) type;
		   s = ty.scope.find(ty.name);
         if (s == null) {
            SemErr("undeclared identifier " + ty.name);
            return this;
         }
         // System.out.println("in RefAST resolveConst: ty.name = " + ty.name);
      } else 
         s = sym;
      // System.out.println("in RefAst resolveConst: s = " + s + " type = " + type);
      if (s.ast == null) return this;
		if (s.ast.isConst()) return s.ast;
		if (s.resolved) return this;
		s.resolved = true;
		return s.ast = s.ast.resolveConst();
	}

   public boolean distributeTypes(boolean isFunBody) {
      // System.out.println("in RefAST distributeTypes");
      if (!valid) {
         if (!(type instanceof UnknownType)) throw new FatalError("internal error in reference");
         UnknownType ty = (UnknownType)type;
         // System.out.println("in RefAST distributeTypes: ty.name = " + ty.name);         
         sym = ty.scope.find(ty.name);
         if (sym == null) {
            SemErr("unknown type " + ty.name);
            return false;
         }
         type = sym.type = sym.type.resolveType();
         valid = true;
         if (sym.kind != Kind.PROCNAME && !sym.mapped) throw new FatalError("variable " + ty.name + " has not been mapped");
         offset = sym.offset;
         readOnly = sym.readOnly;
            
         if ((kind = sym.kind) == Kind.STATICVAR || kind == Kind.SHAREDVAR || kind == Kind.COMPVAR || kind == Kind.LOCALVAR || kind == Kind.FIELDNAME)
            place = Place.CONSTADDR;
         else if (kind == Kind.CONSTNAME)
            place = Place.CONSTVAL;
         else
            place = Place.NOWHERE;      
      }
      // System.out.println("out RefAST distributeTypes: valid = " + valid);
      return valid;
   }

   public TypedAST moveVal2Stack() {
      // System.out.println("in RefAST.moveVal2Stack, kind = " + kind + " , place = " + place);
      if ((kind == Kind.VARPAR || kind == Kind.LOCALVAR) && place == Place.NOWHERE) moveAddr2Stack();
      if (place == Place.VALONSTACK) {
         // System.out.println("out RefAST.moveVal2Stack, place = " + place);
         return this;
      } else if (place == Place.ADDRONSTACK) {
         int s = type.size;
         if (s == 1) Compiler.code.Emit(Instruction.LOADV, isBlob(), "address on stack");
         else Compiler.code.Emit(Instruction.LOADMV, s, type.getBlobOffsets(0), "address on stack");
         place = Place.VALONSTACK;            
      } else if (place == Place.CONSTADDR) {
         int s = type.size;
         if (kind == Kind.STATICVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOAD, offset, isBlob(), "static variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, false, false, type.getBlobOffsets(0), "static variable");
            place = Place.VALONSTACK;
         } else if (kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOAD, offset, isBlob(), "shared or component variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, false, true, type.getBlobOffsets(0), "shared or component variable");
            place = Place.VALONSTACK;
         } else if (kind == Kind.LOCALVAR) {
            if (s == 1) Compiler.code.Emit(Instruction.LOADL, offset, isBlob(), "local variable");
            else Compiler.code.Emit(Instruction.LOADM, offset, s, true, false, type.getBlobOffsets(0), "local variable");
            place = Place.VALONSTACK;
         }
      } else if (kind == Kind.CONSTNAME) {
         // System.out.println("out RefAST.moveVal2Stack");
         return sym.ast;        
      } else {
         throw new FatalError("inconsistent reference placement");
      }
      // System.out.println("out RefAST.moveVal2Stack, place = " + place);
      return this;
   }

   public void forceVal2Stack() {
      // System.out.println("in RefAST.forceVal2Stack");
      if (place != Place.VALONSTACK) {
         throw new FatalError("cannot force value to stack");
      }
      // System.out.println("out RefAST.forceVal2Stack, place = " + place);
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      // System.out.println("in RefAST.qualifyOnStack");
      int o = offset, s = type.size;
      // System.out.println("RefAST.qualifyOnStack, size = " + s);
      // type.dump("RefAST.type = ");
      Compiler.code.Emit(Instruction.XTRACT, baseSize, o, s, blobLst, ""); 
      place = Place.VALONSTACK;
      // System.out.println("out RefAST.qualifyOnStack, place = " + place);
   }
 
  public void moveAddr2Stack(boolean check) {
      // System.out.println("in RefAST.moveAddr2Stack");
      if (kind == Kind.FIELDNAME) {
         place = Place.CONSTADDR;
      }
      if ((kind == Kind.LOCALVAR || kind == Kind.STATICVAR || kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) && place == Place.NOWHERE) {
         place = Place.CONSTADDR;
      }
      if (kind == Kind.VARPAR && place == Place.NOWHERE) {
         Compiler.code.Emit(Instruction.LOADL, offset, false, "");
         place = Place.ADDRONSTACK;
      }
      // System.out.println("out RefAST.moveAddr2Stack, place = " + place);
   }

   public void forceAddr2Stack() {
      // System.out.println("in RefAST.forceAddr2Stack");
      moveAddr2Stack();
      if (place == Place.CONSTADDR) {
         int o = offset;
         if (kind == Kind.STATICVAR) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o), false, "static address");
            place = Place.ADDRONSTACK;
         } else if (kind == Kind.SHAREDVAR || kind == Kind.COMPVAR) {
            Compiler.code.Emit(Instruction.LOAD, Compiler.code.EmitConst(o | 0x80000000), false, "static address");
            place = Place.ADDRONSTACK;
         } else if (kind == Kind.LOCALVAR) {
           Compiler.code.Emit(Instruction.ADDFP, o, "local address");
           place = Place.ADDRONSTACK;
         }
      }
      // System.out.println("out RefAST.forceAddr2Stack, place = " + place);
   }

	public void dump(String left) {
		System.out.println(left + "reference");
      System.out.println(left + "   offset = " + offset);
      type.dump(left + "   ");     
	}

}
