package IRed.spectro.stamped;

public class ReturnAST extends AST {
   TypedAST ret;
   ProcType enc;   

   public ReturnAST(int line, int col, TypedAST ret) {
      super(line, col);
      this.ret = ret;
      enc = null;
   }

   public boolean distributeTypes(boolean isFunBody) {
      if (enc == null) {
         SemErr("RETURN outside a PROCEDURE");
         return false;
      } 
      if (ret == null && enc.retType == null) return true;

      if (ret == null) {
         SemErr("return value missing");
         return false;
      }
      if (enc.retType == null) {
         SemErr("PROCEDURE does not return a value");
         return false;
      }
      if (!ret.distributeTypes()) return false;
      if (!enc.retType.assignable(ret.getType())) {
         SemErr("type missmatch in RETURN");
         return false;
      }
      return true;
   }

   public void setEnclosingProc(ProcType proc) {
      enc = proc;
   }

	public void generateCode(boolean isTry) {
      if (ret == null) {
         if (isTry) {
            Code.Label n = Compiler.code.genLabel();
            Compiler.code.Emit(Instruction.TRYEND, n, "");
            Compiler.code.setLabel(n);
         }
         Compiler.code.Emit(Instruction.RETURN, enc.locals.parSize, "");
      } else {
         ret = ret.moveVal2Stack();
         ret.forceVal2Stack();
         if (isTry) {
            Code.Label n = Compiler.code.genLabel();
            Compiler.code.Emit(Instruction.TRYEND, n, "");
            Compiler.code.setLabel(n);
         }
         Compiler.code.Emit(Instruction.FRETURN, enc.locals.parSize, enc.retType.size, "");
      }
   }

	public void dump(String left) {
         System.out.println(left + "Returnstatement");
         if (ret != null) ret.dump(left + "   ");
   }

}
