package IRed.spectro.stamped;

import java.util.LinkedList;

public class SequenceAST extends AST {
   LinkedList<AST> stmnts;   

   public SequenceAST(int line, int col, AST first) {
      super(line, col);
      stmnts = new LinkedList<AST>();
      if (first != null) stmnts.add(first);
   }

   public void append(AST ast) {
      if (ast != null) stmnts.addLast(ast);
   }

   public boolean distributeTypes(boolean isFunBody) {
      AST lstAst = null;
      for (AST ast: stmnts) {
         if (!ast.distributeTypes()) return false;
         lstAst = ast;
      }
      if (isFunBody && !(lstAst instanceof ReturnAST)) {
         SemErr("function PROCEDURE does not return value");
         return false;
      }
      return true;
   }

   public void setEnclosingProc(ProcType proc) {
      for (AST ast: stmnts) {
         ast.setEnclosingProc(proc);
      }
   }

	public void generateCode(boolean isTry) {
      for (AST ast: stmnts) {
         Compiler.code.Emit(Instruction.NOP, "statement");
         ast.generateCode(isTry);
      }
   }

	public void dump(String left) {
         System.out.println(left + "StatementList");
         for (AST ast: stmnts) ast.dump(left + "   ");
   }

}
