package IRed.spectro.stamped;

public class Symbol {
	DataType type;
	int offset;
	boolean readOnly, mapped;
	boolean resolved;
	TypedAST ast;
		
	Kind kind;

	public Symbol(DataType ty, boolean ro, Kind k) {
		type = ty; readOnly = ro; mapped = false; kind = k; offset = 0; resolved = false;
		ast = null;
	}

	public Symbol(TypedAST a, boolean ro, Kind k) {
		type = a.type; readOnly = ro; mapped = false; kind = k; offset = 0; resolved = false;
		ast = a;
	}

   public Symbol(DataType ty, TypedAST a, boolean ro, Kind k) {
      type = ty; readOnly = ro; mapped = false; kind = k; offset = 0; resolved = false;
      ast = a; 
   }

   public void dump(String left) {
      if (type != null) type.dump(left + "   type =");
      if (ast != null) ast.dump(left + "   ast =");
   }

}


