package IRed.spectro.stamped;

import java.io.DataOutputStream;
import java.io.IOException;

public class TaskAST extends AST {
   String name;
   TypedAST period;
   Trigger trigger;
   SymbolTable taskSyms;
   int taskVarsStart;
   SequenceAST body;
   Code.Label start;
   
   public TaskAST(int line, int col, String name, TypedAST period, Trigger trigger, SymbolTable taskSyms, int taskVarsStart, SequenceAST body) {
      super(line ,col);
      this.name = name; this.period = period; this.trigger = trigger; this.taskSyms = taskSyms; this.taskVarsStart = taskVarsStart; this.body = body;
      start = Compiler.code.genLabel(); 
   }

   public boolean distributeTypes(boolean isFunBody) {
      if (period != null) {
         if (!period.distributeTypes()) return false;
         period = period.resolveConst();
         if (!period.isConst() || !period.isInteger()) {
            SemErr("invalid TASK period");
            return false;
         }
      }
      return body.distributeTypes();
   }

   public void setEnclosingProc(ProcType proc) {}

	public void generateCode(boolean isTry) {
      // taskSyms.dump("in TaskAST generateCode: ");
      // body.dump("in TaskAST generateCode: body = ");
      if (body.distributeTypes()) {
         // body.dump("in TaskAST generateCode, types resolved: body = ");
         Compiler.code.Emit(Instruction.NOP, "Task " + name);
         Compiler.code.setLabel(start);
         body.generateCode(false);
         Compiler.code.Emit(Instruction.STOP, "End of Task " + name);
         taskSyms.generateCode();
      }
   }

	public void dump(String left) {
      System.out.println(left + "Task " + name);
      taskSyms.dump(left + "   ");
      body.dump(left + "   ");
   }

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(name.length());
      out.writeBytes(name);
      out.writeInt(start.addr);
      if (period != null) out.writeInt(((ConstIntAST)period).val);
      else out.writeInt(0);
      out.writeInt(taskVarsStart);
      if (trigger != null) trigger.dumpBinary(out);
      else Trigger.dumpDummyBinary(out);
   }  

}
