package IRed.spectro.stamped;

public class TryAST extends AST {
   AST tryBody, catchBody;

   public TryAST(int line, int col, AST tryBody, AST catchBody) {
      super(line, col);
      this.tryBody = tryBody; this.catchBody = catchBody;
   }

   public boolean distributeTypes(boolean isFunBody) {
      if (!tryBody.distributeTypes()) return false;
      if (!catchBody.distributeTypes()) return false;
      return true;
   }

   public void setEnclosingProc(ProcType proc) {
      tryBody.setEnclosingProc(proc);
      catchBody.setEnclosingProc(proc);
   }

	public void generateCode(boolean isTry) {
      Code.Label catchStrt = Compiler.code.genLabel(), tryCatchEnd = Compiler.code.genLabel();
      Compiler.code.Emit(Instruction.TRY, catchStrt, "");
      tryBody.generateCode(true);
      Compiler.code.Emit(Instruction.TRYEND, tryCatchEnd, "");
      Compiler.code.setLabel(catchStrt);
      catchBody.generateCode(isTry);
      Compiler.code.setLabel(tryCatchEnd);
   }

	public void dump(String left) {
      System.out.println(left + "try");
      tryBody.dump(left + "   ");
      catchBody.dump(left + "   ");
   }

}
