package IRed.spectro.stamped;

import java.util.List;
import java.util.LinkedList;

public class TuppleAST extends TypedAST {
   LinkedList<TypedAST> comps;

	public TuppleAST(int line, int col) {
      super(line, col);
		type = null;
      valid = false;
      comps = new LinkedList<TypedAST>();
	}

   public void append(TypedAST ast) {
      comps.addLast(ast);
   }

	public TypedAST resolveConst() {
      return this;
   }

   public boolean distributeTypes(boolean isFunBody) {
      LinkedList<DataType> compTys = new LinkedList<DataType>();
      for (TypedAST comp: comps) {
         if (!comp.distributeTypes()) return false;
         compTys.addLast(comp.type);
      }      
      type = (new TuppleType(compTys)).resolveType();
      return valid = true;
   }

   public TypedAST moveVal2Stack() {
      for (TypedAST comp: comps) {
         comp = comp.moveVal2Stack();
         comp.forceVal2Stack();
         if (comp.place != Place.VALONSTACK) throw new FatalError("invalid right hand side entry in tupple");
      }
      return this;
   }

   public void forceVal2Stack() {
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public void moveAddr2Stack(boolean check) {
      throw new FatalError("internal error, tupple has no address");
   }

   public void forceAddr2Stack() {
      throw new FatalError("internal error, tupple has no address");
   }

	public void dump(String left) {
      System.out.println(left + "tupple");
      for (TypedAST a: comps) a.dump(left + "   ");
   }

}
