package IRed.spectro.stamped;

import java.util.List;
import java.io.DataOutputStream;
import java.io.IOException;

public class TuppleType extends DataType {
   private List<DataType> compTypes;

	public TuppleType (List<DataType> compTypes) {
		super(0);
      this.compTypes = compTypes;
	}

	public boolean assignable(DataType rhs) {
		return (rhs instanceof TuppleType) && compTypes.equals(((TuppleType)rhs).compTypes);
	}

	public DataType clone() {
		return this;               // pointless to clone
	}

   public boolean equals(Object o) {
		return (o instanceof TuppleType) && compTypes.equals(((TuppleType)o).compTypes);
   }

	public DataType resolveType() {
      // System.out.println("in TuppleType.resolveType");
      if (!resolved) {
         resolved = true;
         for (DataType ty : compTypes) {
            ty.resolveType();
            // System.out.println("resolveType: size of member" + ty.size); 
            size += ty.size;
         }
      }
      // System.out.println("out TuppleType.resolveType");
      return this;
   }

	public void dump(String left) {
		System.out.println(left + "Tupple");
	}

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(Tag.TUPPLE);
      out.writeInt(compTypes.size());
      for (DataType ty: compTypes) ty.dumpBinary(out);
   }

}
