package IRed.spectro.stamped;

import java.util.List;

public abstract class TypedAST extends AST {

   static final long serialVersionUID = 0;

   DataType type;
   Kind kind;
   Place place;
   int offset;
   boolean readOnly;
   boolean valid;

   protected TypedAST() {
      super(0, 0);
   }

   public TypedAST(int line, int col) {
      super(line, col);
      type = null;
      valid = false;
      place = Place.NOWHERE;
   }

   public TypedAST(int line, int col, DataType ty) {
      super(line, col);
      type = ty;
      place = Place.NOWHERE;
   }

   public abstract TypedAST resolveConst();

   public boolean isConst() {
      return (this instanceof ConstBoolAST) || (this instanceof ConstIntAST) || (this instanceof ConstFloatAST) || (this instanceof ConstStringAST);
   }

   public boolean isConstNumber() {
      return (this instanceof ConstIntAST) || (this instanceof ConstFloatAST);
   }

   public boolean isBool() {
      return type instanceof BoolType;
   }

   public boolean isInteger() {
      return type instanceof IntegerType;
   }

   public boolean isFloat() {
      return type instanceof FloatType;
   }

   public boolean isNumber() {
      return type instanceof IntegerType || type instanceof FloatType;
   }

   public boolean isBlob() {
      return type instanceof BlobType;
   }

   public boolean isTimeStamp() {
      return type instanceof TimeStampType;
   }

   public DataType getType() {
      return type;
   }

   public abstract boolean distributeTypes(boolean isFunBody);

   // Generates code for getting the value of the AST onto the stack. If the value is a constant no code is generated,
   // and a ConstantAST is returned instead. Should be called only once! After calling moveVal2Stack the place of the AST can be
   //
   //    - Place.CONSTVAL for constants or 
   //    - Place.VALONSTACK for all other asts.
   //

   public abstract TypedAST moveVal2Stack();

   public abstract void forceVal2Stack();

   // Generates code for moving the address of the dataitem described by the AST onto the stack. Should be called only once!
   // After calling moveAddr2Stack the place of the AST can be
   //
   //    - Place.CONSTADDR nothing is on the stack, offset contains the address of the data item. Allows collapse of constant qualifiers.
   //
   //    - Place.INDEXONSTACK the index of an array reference is on the stack, the base address is constant. For element size > 1 the index is checked and scaled. 
   //      Allows the ArrayRefAST to emit an appropriate LOADAx instruction. 
   // 
   //    - Place.ADDRONSTACK the absolute address is on the stack. A LOADMV instruction will bring the value.
   //
   //    - Place.VALONSTACK after a function call the value is already on the stack. 
   //

   public abstract void moveAddr2Stack(boolean check);

   public void moveAddr2Stack() {
      moveAddr2Stack(false);
   }

   public abstract void qualifyOnStack(int baseSize, List<Integer> blobLst);

   public abstract void forceAddr2Stack();

   public void generateCode(boolean isTry) {
   }

   public abstract void dump(String left);

}
