package IRed.spectro.stamped;

import java.util.List;

public class UnaryOpAST extends TypedAST {
	TypedAST sub;
	Operators op;

	public UnaryOpAST(int line, int col, Operators o, TypedAST s) {
		super(line, col);
		sub = s;
		op = o;
	}

	public TypedAST resolveConst() {
		sub = sub.resolveConst();
		if (op == Operators.NOT && (sub instanceof ConstBoolAST))
			return new ConstBoolAST(!((ConstBoolAST)sub).val);
		if (op == Operators.INVERT && (sub instanceof ConstIntAST))
			return new ConstIntAST(~((ConstIntAST)sub).val);
		if (op == Operators.MINUS) {
			if (sub instanceof ConstBoolAST) return this;
			if (sub instanceof ConstIntAST) 
				return new ConstIntAST(-((ConstIntAST)sub).val);
			else if (sub instanceof ConstFloatAST)
				return new ConstFloatAST(-((ConstFloatAST)sub).val);
		}
		return this;		
	}		

   public boolean distributeTypes(boolean isFunBody) {
      // System.out.println("in UnaryOpAST distributeTypes");
      if (!sub.distributeTypes()) return false;
      DataType subType = sub.getType();
  
		if (op == Operators.NOT && (subType instanceof BoolType))
			type = new BoolType();
		else if (op == Operators.INVERT && (subType instanceof IntegerType))
			type = new IntegerType();
		else if (op == Operators.MINUS && (subType instanceof IntegerType))
         type = new IntegerType();
      else if (op == Operators.MINUS && (subType instanceof FloatType))
         type = new FloatType();
      else {
         SemErr("type missmatch");
         return false;
      }
      // System.out.println("out UnaryOpAST distributeTypes");
		return true;		
   }

   public TypedAST moveVal2Stack() {
      // System.out.println("in UnaryOpAST moveVal2Stack, place = " + place);
      TypedAST res = resolveConst();
      if (res != this) return res;
      sub = sub.moveVal2Stack();
      if (sub.place != Place.VALONSTACK) {
         throw new FatalError("cannot force value to stack");
      }
      if (op == Operators.NOT) {
         Compiler.code.Emit(Instruction.NOT, "");
      } else if (op == Operators.INVERT) {
         Compiler.code.Emit(Instruction.NOT, "");
      } else if (op == Operators.MINUS) {
         if (isInteger()) {
            Compiler.code.Emit(Instruction.NEG, "");
         } else {
            Compiler.code.Emit(Instruction.FNEG, "");
         }
      } else {
         throw new FatalError("invalid unary operator");
      }
      place = Place.VALONSTACK;
      return this;
   }

   public void forceVal2Stack() {
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public void moveAddr2Stack(boolean check) {}

   public void forceAddr2Stack() {}

	public void dump(String left) {
		System.out.println(left + "Operator " + op);
		sub.dump(left + "   ");
	}

}
