package IRed.spectro.stamped;

import java.io.DataOutputStream;
import java.io.IOException;

class UnknownType extends DataType {
	SymbolTable scope;
	String name;

	public UnknownType(SymbolTable s, String n) {
		super(0);
		scope = s;
		name = n;
	}

	private UnknownType(UnknownType orig) {
		super(orig);
		scope = orig.scope;
		name = orig.name;
	}

	public boolean assignable(DataType rhs) {return false;}

	public DataType clone() {
		return new UnknownType(this);
	}

   public boolean equals(Object o) {
      return false;
   }

	public DataType resolveType() {
		Symbol s = scope.find(name);
		// System.out.println("Unknown, resolving " + name + " " + s);
		if (s != null && s.kind == Kind.TYPENAME) {
			if (!s.resolved) {
				s.resolved = true;
				s.type = s.type.resolveType();
			}
			return s.type;
		}
		return this;
	}

   public boolean distributeTypes() {
      return true;
   }

	public void dump(String left) {
		System.out.println(left + "Unknown " + name);
	}

   public void dumpBinary(DataOutputStream out) throws IOException {
      out.writeInt(Tag.NOTYPE);
   }

}
