package IRed.spectro.stamped;

import java.util.List; 

public class toIntegerAST extends TypedAST {
   private TypedAST sub;

   public toIntegerAST (int line, int col, TypedAST sub) {
      super(line, col, new IntegerType());
      this.sub = sub;
   }

	public TypedAST resolveConst() {
      sub = sub.resolveConst();
      if (sub instanceof ConstFloatAST) {
         int v = (int)(((ConstFloatAST)sub).val);
         return new ConstIntAST(v);
      }
      place = Place.VALONSTACK;
      return this;
   }

   public boolean distributeTypes(boolean isFunBody) {
      if (!sub.distributeTypes()) return false;
      if (!sub.isFloat()) return false;
      return true;
   }

   public TypedAST moveVal2Stack() {
      // System.out.println("in toFloatAST moveVal2Stack, place = " + place + " sub.place " + sub.place);
      if (sub.place == Place.CONSTVAL) {
         return resolveConst();
      }
      sub = sub.moveVal2Stack();
      sub.forceVal2Stack();
      if (sub.place != Place.VALONSTACK) {
         throw new FatalError("cannot force value to stack");
      }
      Compiler.code.Emit(Instruction.TOINT, "");
      place = Place.VALONSTACK;
      return this;
   }

   public void forceVal2Stack() {
   }

   public void qualifyOnStack(int baseSize, List<Integer> blobLst) {
      throw new FatalError("internal error, invalid qualification");
   }

   public void moveAddr2Stack(boolean check) {}

   public void forceAddr2Stack() {}

	public void dump(String left) {
      System.out.println(left + "toInteger");
      sub.dump(left + "   ");
   }

}
